Vue.component('patientBpTrack', {

    props: [
        'routes',
        'events',
        'parent',
    ],

    data: function() {
        return {
            records: [],
            loading: false,
            add: false,
            errors: {},
            success: false,
            display: 3,
            defaultBpRecord: {
                id: null,
                low: '',
                high: '',
                heart_rate: '',
            },
            record: {},
            deleteIndex: -1,
            todayDate: null,
            showingAll: false,
            eventIndex: 0,
            reviewID: null,
        };
    },

    mounted: function() {
        this.init();
    },

    watch: {
        events(stack) {
            // Because there may be more than one event at a time, loop through new events
            for (let i = this.eventIndex; i < stack.length; i++) {
                let event = stack[i];
                if (event.name === 'filesUpdated') {
                    this.load();
                }
                if (event.name === 'initReview') {
                    this.reviewID = event.data.reviewId;
                    this.load();
                }
                if (event.name === 'bpTrackUpdated') {
                    this.load();
                }
            }
            // Update event index so that we don't process already processed events
            this.eventIndex = stack.length;
        }
    },

    computed: {
        canShowAll() {
            if (!this.records.length) {
                return false;
            }
            if (this.showingAll) {
                return false;
            }
            return this.records.length > this.display;
        }
    },

    methods: {
        init() {
            this.record = { ...this.defaultBpRecord };
            // Don't load BP records if it's on the review page
            if (this.parent !== 'review') {
                this.load();
            }
        },
        load() {
            this.loading = true;

            let params = {};

            if (this.parent === 'review') {
                if (typeof this.reviewID !== 'undefined' && this.reviewID > 0) {
                    params = {
                        review_id: this.reviewID,
                    };
                }
            }

            let vm = this;

            this.$http.post(this.routes['admin-patient-bp-track-load'], params)
                .then((response) => {

                    const data = response.data;

                    vm.records = data.bpTrack;
                    vm.todayDate = data.todayDate;
                    vm.loading = false;
                    vm.bindImageModal();
                });
        },
        addRecord() {
            this.add = true;
            this.record = { ...this.defaultBpRecord };
            $('#bpTrackDate' + this.parent).val(this.todayDate);
        },
        cancel() {
            this.add = false;
        },
        store() {
            if (this.loading) {
                return;
            }
            this.errors = {};
            this.success = false;
            this.loading = true;

            this.record.date_provided = $('#bpTrackDate' + this.parent).val();
            let formData = new FormData();
            formData.append('file', document.getElementById('bpFile' + this.parent).files[0]);
            Object.keys(this.record).forEach(key => {
                formData.append(key, this.record[key]);
            });
            formData.append('review_id', this.reviewID);

            let vm = this;

            const headers = { 'Content-Type': 'multipart/form-data' }
            this.$http.post(this.routes['admin-patient-bp-track-store'], formData, headers)
                .then((response) => {

                    const data = response.data;

                    if (data.errors) {
                        vm.errors = data.errors;
                        this.loading = false;
                        return;
                    }
                    if (data.success) {
                        vm.success = data.success;
                    }
                    vm.record = { ...vm.defaultBpRecord };
                    vm.add = false;
                    vm.emitEvent('bpTrackUpdated');
                });
        },
        showConfirmDeletion(index) {
            this.deleteIndex = index;
        },
        deleteRecord(id) {
            if (this.loading) {
                return;
            }
            this.errors = {};
            this.success = false;
            this.loading = true;

            let vm = this;

            this.$http.post(this.routes['admin-patient-bp-track-delete'], {
                id: id,
            })
                .then((response) => {

                    const data = response.data;

                    if (data.errors) {
                        vm.errors = data.errors;
                        this.loading = false;
                        return;
                    }
                    if (data.success) {
                        vm.success = data.success;
                    }
                    vm.showConfirmDeletion(-1);
                    vm.emitEvent('bpTrackUpdated');
                });
        },
        showAll() {
            this.showingAll = true;
            this.bindImageModal();
        },
        bindImageModal() {
            this.$nextTick(function () {
                $('.bpTrackImage').mtcOverlay();
            });
        },
        emitEvent(name, data) {
            this.$parent.emitEvent(name, data);
        },
    },
});
