Vue.component('patientConsultations', {

    props: [
        'routes',
        'events',
    ],

    data: function() {
        return {
            records: [],
            loading: false,
            display: 3,
            todayDate: null,
            showingAll: false,
        };
    },

    mounted: function() {
        this.init();
    },

    computed: {
        canShowAll() {
            if (!this.records.length) {
                return false;
            }
            if (this.showingAll) {
                return false;
            }
            return this.records.length > this.display;
        }
    },

    methods: {
        init() {
            this.load();
        },
        load() {
            this.loading = true;
            let vm = this;

            this.$http.post(this.routes['admin-patient-consultations-load'], [])
                .then((response) => {

                    const data = response.data;

                    vm.records = data.consultations;
                    vm.loading = false;
                });
        },
        showAll() {
            this.showingAll = true;
        },
    },
});
