Vue.component('patientEventLog', {

    props: [
        'routes',
        'events',
    ],

    data: function() {
        return {
            records: [],
            filteredRecords: [],
            loading: false,
            display: 5,
            deleteIndex: -1,
            showingAll: false,
            types: [],
            filterOpen: false,
            filterApplied: false,
            imageExtensions: [],
            filter: {
                types: [],
                id: '',
            },
            record: {},
            logEventOpen: false,
            eventIndex: 0,
        };
    },

    mounted: function() {
        this.init();
    },

    computed: {
        canShowAll() {
            if (!this.records.length) {
                return false;
            }
            if (this.showingAll) {
                return false;
            }
            if (this.filterApplied) {
                return false;
            }
            return this.records.length > this.display;
        },
        filterTypes() {
            return this.filter.types;
        },
        filterID() {
            return this.filter.id;
        }
    },

    watch: {
        events(stack) {
            // Because there may be more than one event at a time, loop through new events
            for (let i = this.eventIndex; i < stack.length; i++) {
                let event = stack[i];
                if (event.name === 'bpTrackUpdated') {
                    this.load();
                }
                if (event.name === 'treatmentSaved') {
                    this.load();
                }
                if (event.name === 'treatmentDeleted') {
                    this.load();
                }
                if (event.name === 'flagsChanged') {
                    this.load();
                }
                if (event.name === 'weightTrackUpdated') {
                    this.load();
                }
            }
            // Update event index so that we don't process already processed events
            this.eventIndex = stack.length;
        },
        filterTypes () {
            this.runFilter();
        },
        filterID () {
            this.runFilter();
        }
    },

    methods: {
        init() {
            this.load();
        },
        load() {
            this.loading = true;
            let vm = this;

            this.$http.post(this.routes['admin-patient-event-log-load'], [])
                .then((response) => {

                    const data = response.data;

                    vm.records = data.events;
                    vm.types = data.types;
                    vm.imageExtensions = data.imageExtensions;
                    vm.loading = false;
                    vm.bindEventLogModal();
                    vm.runFilter();
                });
        },
        typeName(type) {
            if (!type.length) {
                return '-';
            }
            return this.types[type];
        },
        showAll() {
            this.showingAll = true;
            this.bindEventLogModal();
        },
        bindEventLogModal() {
            let vm = this;
            this.$nextTick(function () {
                $('.eventLogModalButton').mtcOverlay({
                    onClose() {
                        vm.record = {};
                        vm.logEventOpen = false;
                    },
                });
            });
        },
        emitEvent(name, data) {
            this.$parent.emitEvent(name, data);
        },
        viewRecord(record) {
            this.record = record;
            this.logEventOpen = true;
        },
        toggleFilter() {
            this.filterOpen = !this.filterOpen;
        },
        showRow(index) {
            if (this.showingAll) {
                return true;
            }
            if (this.filterApplied) {
                return true;
            }
            return index + 1 <= this.display;
        },
        runFilter() {
            this.filterApplied = false;

            let tempRecords = this.filterByType(this.records);
            this.filteredRecords = this.filterByID(tempRecords);
        },
        filterByType(records) {
            if (this.filter.types.length === 0) {
                return [...records];
            }
            let tempRecords = [];
            for (let i = 0; i < records.length; i++) {
                if (this.filter.types.includes(records[i].subject)) {
                    tempRecords.push(records[i]);
                }
            }
            this.filterApplied = true;
            return tempRecords;
        },
        filterByID(records) {
            if (this.filter.id.length === 0) {
                return [...records];
            }
            let tempRecords = [];
            for (let i = 0; i < records.length; i++) {
                if (this.filter.id == records[i].loggable_id) {
                    tempRecords.push(records[i]);
                }
            }
            this.filterApplied = true;
            return tempRecords;
        },
        isImage(extension) {
            return this.imageExtensions.includes(extension);
        },
        normaliseDetailsKey(key) {
            return key.replace('_', ' ');
        },
        normaliseDetailsValue(value) {
            return JSON.stringify(value, null, 2);
        },
    },
});
