Vue.component('patientMessages', {

    props: [
        'routes',
        'events',
    ],

    data: function() {
        return {
            records: [],
            loading: false,
            display: 3,
            showingAll: false,
        };
    },

    mounted: function() {
        this.init();
    },

    computed: {
        canShowAll() {
            if (!this.records.length) {
                return false;
            }
            if (this.showingAll) {
                return false;
            }
            return this.records.length > this.display;
        }
    },

    methods: {
        init() {
            this.load();
        },
        load() {
            this.loading = true;
            let vm = this;

            this.$http.post(this.routes['admin-patient-messages-load'], [])
                .then((response) => {

                    const data = response.data;

                    vm.records = data.threads;
                    vm.loading = false;
                });
        },
        showAll() {
            this.showingAll = true;
        },
        toggleMessages(index) {
            if (typeof this.records[index].visible === 'undefined') {
                this.$set(this.records[index], 'visible', true);
                return;
            }
            this.$set(this.records[index], 'visible', !this.records[index].visible);
        }
    },
});
