<?php
use Mtc\Plugins\ComplimentedItems\Classes\ComplimentedItems;
use \Illuminate\Support\Facades\Event;
use \Mtc\Shop\Events\ItemAdminTabnavEvent;

/**
 * Complimented items hooks
 *
 * @author Martins Fridenbergs <martings.fridenberg@mtcmedia.co.uk>
 */

if (defined('COMPLIMENTED_ITEMS') && COMPLIMENTED_ITEMS === true) {
    Event::listen(
        'Mtc\Shop\Events\ItemAdminTabnavEvent',
        function (ItemAdminTabnavEvent $event) use ($twig) {
            return ComplimentedItems::addTabNav($event->getItem(), $event->getRequest(), $twig);
        }
    );

    HooksAdapter::add_action(
        'render_item',
        '\Mtc\Plugins\ComplimentedItems\Classes\ComplimentedItems::getComplimented',
        10,
        1
    );
}
