<?php

namespace Mtc\Plugins\MembersMessaging\Classes;

use Illuminate\Database\Eloquent\Model as Eloquent;
use Mtc\Core\Admin\User;
use Mtc\Modules\Members\Models\Member;

class Participant extends Eloquent
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'messenger_participants';

    /**
     * The attributes that can be set with Mass Assignment.
     *
     * @var array
     */
    protected $fillable = [
        'thread_id',
        'member_id',
        'last_read',
        'admin'
    ];

    /**
     * Thread relationship.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     *
     * @codeCoverageIgnore
     */
    public function thread()
    {
        return $this->belongsTo(Thread::class, 'thread_id', 'id');
    }

    /**
     * User relationship.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     *
     * @codeCoverageIgnore
     */
    public function user()
    {
        return $this->belongsTo(Member::class, 'member_id');
    }

    /**
     * Admin User relationship.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     *
     * @codeCoverageIgnore
     */
    public function adminUser()
    {
        return $this->belongsTo(User::class, 'member_id');
    }
}
