<?php

namespace Mtc\Plugins\NHS\Http\Controllers;

use App\Http\Controllers\Controller;
use Mtc\Modules\Members\Models\Member;

class AdminController extends Controller
{

    public function overview()
    {


        $members = Member::query()
            ->get();

        $hierarchy = [];

        foreach ($members as $member) {

            if ($member->referrer) continue;

            if (! isset($hierarchy[$member->email])) {
                $hierarchy[$member->email] = [
                    'prescriptions' => [],
                    'patients' => [],
                ];
            }

            if ($member->nhs_member->is_patient) {

                foreach ($member->nhs_member->prescriptions as $prescription) {
                    $hierarchy[$member->email]['prescriptions'][$prescription->uuid] = [];

                    foreach ($prescription->items as $prescription_item) {
                        $hierarchy[$member->email]['prescriptions'][$prescription->uuid][] = $prescription_item->name;
                    }
                }

            } else {

                foreach ($member->referred_members as $patient) {
                    if (! isset($hierarchy[$member->email]['patients'][$patient->email])) {
                        $hierarchy[$member->email]['patients'][$patient->id] = [
                            'email' => $patient->email,
                            'prescriptions' => [],
                        ];
                    }

                    foreach ($patient->nhs_member->prescriptions as $prescription) {
                        $hierarchy[$member->email]['patients'][$patient->id]['prescriptions'][$prescription->uuid] = [];

                        foreach ($prescription->items as $prescription_item) {
                            $hierarchy[$member->email]['patients'][$patient->id]['prescriptions'][$prescription->uuid][] = $prescription_item->name;
                        }
                    }
                }

            }

        }




        \Util::var_dump($hierarchy);
        die;

    }


}
