<?php

$page_meta['title'] = 'Dashboard';

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';
$messages = [];

$page_meta['title'] = $page_meta['page_title'] = "Your Medication";

// Have to be logged in
if (! $member->exists) {
    header("Location: " . route('members-login'));
    exit;
}
// Only usable if the user has signed up to become an NHS member.
if (! $member->nhs_member) {
    header('Location: /members/nhs/registration.php');
    exit;
}

if (filter_input(INPUT_GET, 'error') === 'items_in_basket') {
    $messages[] = [
        'content' => 'You have non-NHS items in your basket! Please make sure you purchase or remove these before adding NHS items',
        'type' => 'error'
    ];
}

if (filter_input(INPUT_POST, 'action') === 'update_reminder_details') {
    $member->prescription_reminder_email = filter_input(INPUT_POST, 'prescription_reminder_email');
    $member->prescription_reminder_sms = filter_input(INPUT_POST, 'prescription_reminder_sms');
    $member->save();

    $messages[] = [
        'content' => 'Reminder notification settings updated',
        'type' => 'success'
    ];
}

$self = $_SERVER['REQUEST_URI'];
$is_admin = !empty($_SESSION['adminId']);
$min_order_date = \Carbon\Carbon::now()->format('d/m/Y');

$twig->display('NHS/prescriptions/index.twig', compact('member', 'page_meta', 'self', 'messages', 'is_admin', 'min_order_date'));