# Wiki
http://wiki.mtcmedia.co.uk/index.php?title=Core_Plugin_-_Newsletter_Signup#Installation

# Installation
Clone the repository into `~/public_html/plugins/NewsletterSignup/`:

```bash
cd ~/public_html
git clone https://YOUR_BITBUCKET_ACCOUNT@bitbucket.org/mtcmedia/core-plugins-newslettersignup.git ~/public_html/plugins/NewsletterSignup
```
```bash
composer update
```

__NB__ If you are using Campaign Monitor for the mail integration, please run
```bash
composer require campaignmonitor/createsend-php 5.1.*
```

__NB__ If you are using Mailchimp for the mail integration, please run
```bash
composer require drewm/mailchimp-api:^2.5
```

When you next visit the site your settings constants will be automatically created. The plugin will then create a page called Newsletter in the CMS as a subpage of the contact page if it exists and has an ID of 4 (which it should if you set this up immediately after install of the core/cms) else it will create it as main page. It will then create `emails_lists` if it doesn't exist and populate it accordingly. It will then create `emails_lists_mails` if it doesn't exist. Results will be added to this table as expected. Table `emails_double_optin` for Double Opt-in will be created if not exist

All of this will happen only once per site if `NEWSLETTER_SIGNUP_INSTALLED` is not defined in the settings.

# Redirect rule

`RewriteRule ^newsletter(/)?$ /plugins/NewsletterSignup/ [QSA,L]`

# Usage
Update the settings in the admin as required

- `NEWSLETTER_PAGE_ID` // ID of newsletter page. Allows plugin to take pagedata from the cms page
- `POPUP` // Enable/Disable Newsletter Signup popup overlay
- `POPUP_DELAY` // In milliseconds set delay after page load to show popup
- `POPUP_AFTER_PAGE_VISITS` // Set to how many pages user must view before being shown the popup
- `POPUP_SHOW_ONLY_ONCE` // Set to true to prevent popup from showing for 365days else cookie clears after session ends

Include the template file where you want to output the newsletter signup form in your project. This can be in multiple place in the site including the footer

```bash
{% include('includes/pages/newsletter/newsletter_form.twig') %}
```

# Edit the Template
Should you wish to tailor any of the files within this plugin be sure to copy the file into the relevant place within your sites folder... it will then override the plugin version of the template.

# Double Opt-in

Double opt-in sends a activation email to subscriber. Email contains activation link with hash, which when opened will actually add subscriber to newsletter list

# Unsubscribe

You must include some way of users unsubscribing from the newsletter somewhere on the site.  Adding the [Unsubscribe plugin](https://bitbucket.org/mtcmedia/core-plugins-unsubscribe) will create an unsubscribe link at /unsubscribe so users can block themselves from the system.
