Vue.component('private-prescriptions', {
    data: function () {
        return {
            eu_prescription: 1,
            send_hard_copy: 0,
            quote_match: 0,
            quote_match_text: '',
            term: '',
            name: '',
            email: '',
            email_confirm: '',
            contact_no: '',
            dosages: [],
            prescriptions: [],
            errors: [],
            medication_list: [],
            medications: [],
            resource: '/private_prescriptions/ajax.php',
            search_started: false,
            loading: false
        };
    },
    created: function () {
        // Get the user's current medication.
        this.$http.get(this.resource).then(function (response) {
            this.prescriptions = response.data.prescriptions;
            this.dosages = response.data.dosages;
        });


    },
    computed: {
        medications: function () {
            return this.medication_list.map(this.returnName);
        }
    },
    methods: {
        returnName: function (entry) {
            return entry.name;
        },

        // Add a blank line
        add: function (term) {

            // verify that term is part of the medication list
            if (this.medications.indexOf(term) === -1) {
                return;
            }

            var item = this.medication_list[this.medications.indexOf(term)];

            this.prescriptions.push({
                name: item.name,
                price: item.price,
                pack_size: item.pack_size,
                quantity: '',
                dosage_id: this.dosages[0].id,
                dosage: this.dosages[0]
            });
            this.term = '';
            this.medication_list = [];

            if(this.prescriptions.length > 0) {
                setTimeout(function(){

                    if($("#presciptionResults").length > 0) {
                        var offset = $("#presciptionResults").offset();

                        if (typeof offset != 'undefined') {
                            $('html, body').animate({
                                scrollTop: $("#presciptionResults").offset().top
                            }, 1000);
                        }
                    }
                },100);
            }
        },
        // Use datalist to create a list of medications in an autocomplete
        getMedications: function (name) {

            var vm = this;
            vm.loading = true;

            if (name.length < 3) {
                this.medication_list = [];
                return true;
            }

            this.$http.post(this.resource, {search: name}).then(function (response) {
                this.medication_list = response.data;
                this.search_started = true;
                vm.loading = false;
            });
        },
        checkout: function () {
            this.errors = [];
            this.$http.post(this.resource, {
                action: 'save',
                prescriptions: this.prescriptions,
                quote_match: this.quote_match,
                quote_match_text: this.quote_match_text,
                eu_prescription: this.eu_prescription,
                send_hard_copy: this.send_hard_copy
            }).then(function (response) {
                if (response.data.status === 'ok') {
                    window.location = '/shop/checkout/basket.php';
                } else {
                    this.errors = response.data.messages;
                }
            });
        },
        // Enable the 'edit' mode and add a blank prescription if this doesn't exist
        edit: function () {
            this.editing = true;
            if (this.prescriptions.length === 0) {
                this.add();
            }
        }
    }
});
