<?php

use \Mtc\Plugins\ShareButtons\Classes\ShareButtons;

/**
 * Loader file for the Social Buttons
 *
 * @author Andrew Morgan <andrew.morgan@mtcmedia.co.uk>
 */

// Run install script if necessary
if (defined('SHARE_BUTTONS_INSTALLED') === false) {
    require_once __DIR__ . '/admin/install/install.php';
}

$twig->addFunction(new \Twig\TwigFunction('follow_buttons', function ($template = 'social/follow_buttons.twig') use ($twig) {

    $follow_buttons = (new ShareButtons())->where('hide', 0)->orderBy('order', 'ASC')->get();

    echo $twig->render($template, compact('follow_buttons'));

}));

$twig->addFunction(new \Twig\TwigFunction('add_this_default', function ($template = 'social/add_this_default.twig') use ($twig) {

    echo $twig->render($template);

}));

$twig->addFunction(new \Twig\TwigFunction('share_this_default', function ($template = 'social/share_this_default.twig') use ($twig) {

    echo $twig->render($template);

}));
