<?php
/**
 * Breadcrumbs
 *
 * @category Plugins
 * @package  Mtc_Site_Menu
 * @author   mtc. Dawid Bestrzynski <dawid.bestrzynski@mtcmedia.co.uk>
 */

namespace Mtc\Plugins\SiteMenu\Classes;

use Mtc\Plugins\SiteMenu\Classes\SiteMenu;

if (!empty($_REQUEST['id'])) {
    $breadcrumbs = SiteMenu::find($_REQUEST['id'])->getBreadcrumbs();
} elseif (!empty($_REQUEST['menu_id'])) {
    $current_menu = $menu->parentMenu ? $menu->parentMenu : new SiteMenu;
    $breadcrumbs  = $current_menu->getBreadcrumbs();
} elseif (!empty($_REQUEST['parent_id'])) {
    $breadcrumbs = SiteMenu::find($_REQUEST['parent_id'])->getBreadcrumbs(false);
} else {
    $menu = new SiteMenu;
    $breadcrumbs = $menu->getBreadcrumbs();
}

foreach ($breadcrumbs as $breadcrumb) { ?>
<li <?= $breadcrumb['end_class'] ? ' class="end"' : ''; ?>>
    <?= !$breadcrumb['end_class'] ? '<a href="' . $breadcrumb['url'] . '">' : ''; ?>
    <?= $breadcrumb['title']; ?>
    <?= !$breadcrumb['end_class'] ? '</a> /' : ''; ?>
</li>
<?php
} ?>

