# Installation
Clone the repository into: `~/public_html/plugins/TrustpilotAPI/`

```bash
cd ~/public_html
git clone https://YOUR_BITBUCKET_ACCOUNT@bitbucket.org/mtcmedia/core-plugins-trustpilotapi.git ~/public_html/plugins/TrustpilotAPI
```

```bash
Run 'composer update' from the command line.
```
When you next visit the site your settings constants and the tables will be automatically created. 

All of this will happen only once per site if `TRUSTPILOT_API_ENABLED` is not defined in the settings. 

# Usage

a. **Update the settings in the admin area as required**

- `TRUSTPILOT_API_ENABLED` // Enable/Disable the feature
- `TRUSTPILOT_API_REVIEWS` // Enable/Disable trustpilot product reviews
- `TRUSTPILOT_API_KEY` // Trustpilot API key
- `TRUSTPILOT_API_SECRET` // Trustpilot API secret key
- `TRUSTPILOT_API_BUSINESS_ID` // Trustpilot business unit ID
- `TRUSTPILOT_API_ENABLE_CACHE` // Enable/Disable truspilot cache
- `TRUSTPILOT_API_CACHE_TIME` // Cache time in seconds (Default 3600) 

Getting started with Trustpilot's APIs: [Documentation Here](https://support.trustpilot.com/hc/en-us/articles/207309867-Getting-started-with-Trustpilot-s-APIs)

b. **Go to the admin area of the plugin and log in to trustpilot using the trustpilot login details: **

- /plugins/TrustpilotAPI/admin/ 
- "Status : active" message should be displayed after a succesfully login. At that stage the access and refresh token are generated. 

c. **Include the template file where you would like to output the trustpilot product reviews on the item page for your project. **

```bash
<!-- TrustPilot Product Reviews -->
{% include('trustpilot_reviews.twig') with {trustpilot_reviews : reviews, all_reviews : all_reviews} %}
```

d. **Set up the following cron jobs:**

- refresh the access tokens (```0 0	* *	0```)

```bash
/usr/local/bin/php ~/public_html/plugins/TrustpilotAPI/scheduled/refresh.oauth.token.php --site="site" > /dev/null 2>&1
```

- sending out product review invitations (```0 8 *	* *```), invitiations are sent out to customers after 3 weeks of placing an order. 

```bash
/usr/local/bin/php ~/public_html/plugins/TrustpilotAPI/scheduled/send.invitations.php --site="site" > /dev/null 2>&1
```

# Edit Twig Templates

Should you wish to tailor any of the files within this plugin be sure to copy the file into the relevant place within your sites folder... it will then override the plugin version of the template.

**Available Templates:**

a. Product Reviews
```bash
~/public_html/plugins/TrustpilotAPI/templates/trustpilot_reviews.twig
```

b. Product Review Invitation Email
```bash
~/public_html/plugins/TrustpilotAPI/templates/email/review.invitation.twig
```

# Wiki page
[Wiki Documentation Here](http://wiki.mtcmedia.co.uk/index.php?title=Core_Plugin_-_TrustpilotAPI)
