<?php

namespace Mtc\Plugins\Wisebee\Classes\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Accessors
 *
 * @property int $id
 * @property int $wisebee_id
 * @property int $consultation_id
 * @property int $documentable_id
 * @property string $documentable_type
 * @property string $status
 * @property string $file
 * @property string $pages
 * @property Carbon $updated_at
 * @property Carbon $created_at
 *
 */

class WisebeeDocument extends Model
{
    protected $table = 'wisebee_documents';

    protected $fillable = [
        'wisebee_id',
        'consultation_id',
        'documentable_id',
        'documentable_type',
        'title',
        'status',
        'file',
        'pages',
    ];

    protected $casts = [
        'pages' => 'array',
    ];

    const STATUS_NEW = 'new';
    const STATUS_REVIEWED = 'reviewed';

    const FILE_PATH = '/uploads/documents/';

    public function consultation(): BelongsTo
    {
        return $this->belongsTo(WisebeeConsultation::class, 'consultation_id');
    }

    /**
     * Get patient wisebee documents
     *
     * @param $memberID
     * @return Collection
     */
    public static function getPatientDocuments($memberID): Collection
    {
        return self::query()
            ->whereHas('consultation', function (Builder $query) use ($memberID) {
                $query->whereHas('participants', function (Builder $query) use ($memberID) {
                    $query->where('type', WisebeeParticipant::TYPE_CUSTOMER)
                        ->whereHas('customer', function (Builder $query) use ($memberID) {
                            $query->where('member_id', $memberID);
                        });
                });
            })
            ->get();
    }
}