<?php
use Mtc\Shop\Brand;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Support\Facades\Event;
use Mtc\Shop\Events\ModelFormFooter;
use MtcPharmacy\Multisite\Classes\MultisiteManager;


$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

$errors = [];
$message = '';
$id = !empty($_REQUEST['id']) ? (int)$_REQUEST['id'] : 0;
if (!empty($_SESSION['message_brand'])) {
    $message = $_SESSION['message_brand'];
    unset($_SESSION['message_brand']);
}

try {
    $brand = Brand::findOrFail($id);
    $add_edit = 'Edit';

    $mm = new MultisiteManager($brand);
    $mm->ensureTheCorrectAdminPageLoaded();

} catch (ModelNotFoundException $e) {
    $brand = new Brand();
    $add_edit = 'Add';
    if ($id > 0) {
        $errors[] = 'Failed to find brand, new one will be created on save';
    }
}

$page_meta['title'] = $add_edit . ' Brand';


if ($_REQUEST['action'] == 'update_brand') {
    if (empty($_REQUEST['name'])) {
        $errors['name'] = 'You must enter a brand name';
    }

    if (empty($errors)) {

        $brand->fill($_REQUEST);
        // Pass these values separately as checkbox works differently
        $brand->hide = !empty($_REQUEST['hide']) ? 1: 0;

        if (BRANDS_IMAGES === true) {
            if (!empty($_FILES['image_file']['size'])) {
                $folders = $image_folders['brand_images'];
                $file_data = upload_image('image_file', $folders);
                if (!empty($file_data['error'])) {
                    $errors[] = $file_data['error'];
                } else {
                    $brand->image = $file_data['name'];
                }
            } elseif (!empty($_REQUEST['delete_image']) && !empty($brand->image)) {
                foreach ($image_folders['brand_images'] as $folder) {
                    unlink(SITE_PATH . '/' . $folder['path'] . '/' . $brand->image);
                }
                $brand->image = '';
            }
        }

        if (BRANDS_LOGOS === true) {
            if (!empty($_FILES['logo_file']['size'])) {
                $folders = $image_folders['brand_logos'];
                $file_data = upload_image('logo_file', $folders);
                if (!empty($file_data['error'])) {
                    $errors[] = $file_data['error'];
                } else {
                    $brand->logo = $file_data['name'];
                }
            } elseif (!empty($_REQUEST['delete_logo']) && !empty($brand->logo)) {
                foreach ($image_folders['brand_logos'] as $folder) {
                    unlink(SITE_PATH . '/' . $folder['path'] . '/' . $brand->logo);
                }
                $brand->logo = '';
            }
        }

        $brand->save();
        $message = 'Brand Updated';
        if ($add_edit == 'Add') {
            $_SESSION['message_brand'] = 'Brand Added';
            header('Location: /shop/admin/brands/edit.brands.php?id=' . $brand->id);
            exit();
        }
    }
}

require_once $path . 'core/admin/templates/adminheader.html.php';
?>

<?php Event::dispatch('AdminBeforeBreadcrumbs', [ $brand->exists ? $brand : null ]); ?>

    <ul class="breadcrumbs el">
        <li><a href="/admin/">Home</a> /</li>
        <li><a href="manage.brands.php">Brands</a> /</li>
        <li class="end"><?= clean_page($add_edit) ?> Brand</li>
    </ul>

    <h1><?= clean_page($add_edit) ?> Brand</h1>

<?php
include 'tabnav.php';
if (!empty($message)) {
    echo showmsg($message, "success", $path);
}
if (sizeof($errors) > 0) {
    showerrors($errors);
}
$url_params = [
    'id' => $brand->id
];
?>

    <form action="<?= Util::add_query_arg($url_params) ?>"
          method="POST"
          enctype="multipart/form-data"
          class="style">
        <fieldset class="show">
            <h1>
                <a class="show el">
                    Brand Information
                    <i class="fa fa-caret-right"></i>
                </a>
            </h1>

            <div class="row">
                <label for="brand_name">
                    Name
                </label>
                <input type="text"
                       name="name"
                       id="brand_name"
                       value="<?= clean_page($brand->name) ?>"
                       class="INPUT1">
            </div>
            <?php


            if (true) {
                ?>
                <div class="row">
                    <label for="description">
                        Description
                    </label>
                    <textarea name="description"
                              class="simpletinymce"
                              id="description"><?= clean_page($brand->description) ?></textarea>
                </div>
                <?php
            }
            ?>
        </fieldset>

        <?php
        if (BRANDS_LOGOS === true) {
            ?>
            <fieldset class="show">
                <h1>
                    <a class="show el">
                        Logo
                        <i class="fa fa-caret-right"></i>
                    </a>
                </h1>
                <?php
                if (!empty($brand->logo)) {
                    ?>
                    <div class="row">
                        <label for="image">
                            Logo
                        </label>
                        <img src="<?= SITE_URL . '/' . $image_folders['brand_logos']['small']['path']
                            . '/' . clean_page($brand->logo); ?>">
                    </div>
                    <div class="row">
                        <label for="delete_logo">
                            Delete
                        </label>
                        <input type="checkbox"
                               name="delete_logo"
                               id="delete_logo">
                    </div>
                    <?php
                }
                ?>
                <div class="row">
                    <label for="branding">
                        File (<?= $image_folders['brand_logos']['small']['width'] ?>px
                        x <?= $image_folders['brand_logos']['small']['height'] ?>px)
                    </label>
                    <input type="file"
                           name="logo_file"
                           id="branding">
                </div>
            </fieldset>
            <?php
        }

        if (BRANDS_IMAGES === true) {
            ?>
            <fieldset class="<?= !empty($brand->id) ? 'show' : '' ?>">
                <h1>
                    <a class="show el">
                        Image
                        <i class="fa fa-caret-right"></i>
                    </a>
                </h1>
                <?php
                if (!empty($brand->image)) {
                    ?>
                    <div class="row">
                        <label for="image">Image</label>
                        <img src="<?= SITE_URL . '/' . $image_folders['brand_images']['small']['path']
                            . '/' . clean_page($brand->image); ?>">
                    </div>
                    <div class="row">
                        <label for="delete_image">
                            Delete
                        </label>
                        <input type="checkbox"
                               name="delete_image"
                               id="delete_image">
                    </div>

                    <?php
                } ?>
                <div class="row">
                    <label for="branding_image">
                        File
                    </label>
                    <input type="file"
                           name="image_file"
                           id="branding_image">
                </div>
            </fieldset>
            <?php
        }
        ?>

        <?php
        if (EDITABLE_META_DATA === true) {
            ?>
            <fieldset class="<?= !empty($brand->id) ? 'show' : '' ?>">
                <h1>
                    <a class="show el">
                        SEO
                        <i class="fa fa-caret-right"></i>
                    </a>
                </h1>
                <div class="row">
                    <label for="seo_title">
                        Page Title
                    </label>
                    <input type="text"
                           name="seo_title"
                           id="seo_title"
                           value="<?= clean_page($brand->seo_title) ?>" class="long">
                </div>
                <div class="row">
                    <label for="seo_keywords">Meta Keywords</label>
                    <input name="seo_keywords"
                           id="seo_keywords"
                           type="text"
                           value="<?= clean_page($brand->seo_keywords) ?>"
                           class="long"/>
                </div>
                <div class="row">
                    <label for="seo_description">
                        Meta Description
                    </label>
                    <input name="seo_description"
                           id="seo_description"
                           type="text"
                           value="<?= clean_page($brand->seo_description) ?>"
                           class="long"/>
                </div>
            </fieldset>
            <?php
        }
        
        Event::dispatch(new ModelFormFooter($brand));
        ?>

        <input type="hidden" name="action" value="update_brand"/>
        <div class="row">
            <input type="submit" value="Save"/>
            <?php
            if (!empty($brand->id)) {
                ?>
                <a href="<?= browse_url(0, $brand->id) ?>"
                   class="btn actionButton secondaryActionButton"
                   target="_blank">
                    View this brand
                </a>
                <?php
            }
            ?>
        </div>
    </form>
<?php
require_once $path . 'core/admin/templates/adminfooter.html.php';
