<?php

use Mtc\Shop\StandardTemplateLetter;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

init_request_values([
    'page' => null,
]);

$page_meta['title'] = 'Manage Letter Templates';

if ($_REQUEST['action']=='delete' && is_numeric($_REQUEST['delete_id'])) {
    StandardTemplateLetter::query()
        ->where('id', '=', $_REQUEST['delete_id'])
        ->delete();
}

require_once $path .'core/admin/templates/adminheader.html.php';

$query = StandardTemplateLetter::query();

$totalnumrows = $query->count();

if ($_REQUEST['page']=='') {
    $_REQUEST['page'] = 1;
}

$rowsPerPage = 25;
$pageNum = $_REQUEST['page'];
$offset = ($pageNum - 1) * $rowsPerPage;
$standardTemplateLetters = $query
    ->take($rowsPerPage)
    ->skip($offset)
    ->get();
$pagestoshow = 10;
?>

<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li class="end">Default email text</li>
</ul>

<h1>Default email text</h1>
<?php

include 'tabnav.php';

if ($standardTemplateLetters->count() > 0) {
    ?>
    <table class="manage-items">
        <tr>
            <th>Letter</th>
            <th class="center">Edit</th>
            <th class="center">Delete</th>
        </tr>
        <tbody class="tabular">
        <?php
        foreach ($standardTemplateLetters as $standardTemplateLetter) {
            ?>
            <tr id="rorder-<?=$standardTemplateLetter->id?>">
                <td>
                    <?= $standardTemplateLetter->title;?>
                </td>
                <td class="center">
                    <a href="edit.letter.templates.php?id=<?= $standardTemplateLetter->id;?>"
                       class="edit picto"
                    >
                        <i class="fa fa-pencil"></i>
                    </a>
                </td>
                <td class="center">
                    <a href="manage.letter.templates.php?action=delete&delete_id=<?= $standardTemplateLetter->id;?>"
                       class="alert picto error"
                       title="Are you sure you want to delete this template?"
                    >
                        <i class="fa fa-times-circle"></i>
                    </a>
                </td>
            </tr>
            <?php

        }
        ?>
        </tbody>
    </table>
    <?php
    } else {
        ?>
        <p>You have not added any templates</p>
        <?php
    }

include $path . 'core/admin/templates/pagination.php';

require_once $path .'core/admin/templates/adminfooter.html.php';
