<?php

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

$page_meta['title'] = 'Manage Delivery Costs';
$message = false;

// Sets messages based on sessions flash message
if (!empty($_SESSION['flash_message'])) {
    $flash_message = $_SESSION['flash_message'];
    unset($_SESSION['flash_message']);

    switch ($flash_message['type']) {
        case 'success':
            $message = $flash_message['message'];
            break;
        case 'error':
            $errors = $flash_message['message'];
            break;
    }
}

if ($_REQUEST['action'] == 'update') {
    foreach ($_REQUEST['cost'] as $country => $cost) {
        DeliveryMethod::query()
            ->where('id', $country)
            ->update([
                'cost' => $cost,
                'item_combined_cost' => !empty($_REQUEST['item_combined_cost'][$country]) ?
                    $_REQUEST['item_combined_cost'][$country] :
                    0,
                'name' => $_REQUEST['name'][$country]
            ]);
    }

    foreach ($_REQUEST['max'] as $id => $max) {
        DeliveryMethod::query()
            ->where('id', $id)
            ->update([
                'max' => $max,
            ]);
    }

    foreach ($_REQUEST['min'] as $id => $min) {
        DeliveryMethod::query()
            ->where('id', $id)
            ->update([
                'min' => $min,
            ]);
    }

    foreach ($_REQUEST['disable'] as $id => $disable) {
        DeliveryMethod::query()
            ->where('id', $id)
            ->update([
                'disable' => !empty($disable),
            ]);
    }
    $message = 'Delivery methods updated';
}

  //Delete The Delivery
if (!empty(filter_input(INPUT_GET, 'action')) && filter_input(INPUT_GET, 'action') == 'delete' && is_numeric(filter_input(INPUT_GET, 'delete_id')) && ADMIN_DELETE_DELIVERY_METHODS == true) {
    $delivery_method = DeliveryMethod::find(filter_input(INPUT_GET, 'delete_id'));
    $delivery_method->delete();
    header('Location: manage.delivery.php');
    exit;
}


/* * ***********************************************************************************************************************************
 * 														OUTPUT
 * *********************************************************************************************************************************** */

require_once $path . 'core/admin/templates/adminheader.html.php';
?>

<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li class="end">Manage Delivery Costs</li>
</ul>

<h1>Manage Delivery Costs</h1>

<ul class="tabnav el">
    <li class="selected"><a href="#">Manage</a></li>
    <?php if (ADMIN_ADD_DELIVERY_METHODS == true) { ?>
        <li ><a href="edit.delivery.php">Add new Shipping Charge</a></li>
    <?php } ?>
</ul>

<?php
if (!empty($errors)) {
    showerrors($errors);
}
if (!empty($message)) {
    echo showmsg($message, "success", $path);
}

$zones = DeliveryMethod::query()
    ->distinct()
    ->select('zone')
    ->orderBy('zone')
    ->get()
    ->toArray();

if (!empty($zones)) {
    foreach ($zones as $data) {
        $flag = 0;
        ?>
        <h2 id="zone<?= $data['zone'] ?>" style="float:left;clear:both;width:100%;display:block">
            Zone <?= $data['zone']; ?> Costs
        </h2>
        <p>
            <?php
            if (is_array(${'zone' . $data['zone']})) {
                echo clean_page(implode(', ', ${'zone' . $data['zone']}));
            }
            ?>
        </p>
        <?php
        $deliveryMethods = DeliveryMethod::query()
            ->where('zone', $data['zone'])
            ->orderBy('order')
            ->orderBy('name')
            ->get();

        if ($deliveryMethods->count() > 0) {
            ?>
            <form method="post" action="">
                <table class="manage-items">
                    <tr>
                        <th>Delivery Method</th>
                        <?php
                        if (DELIVERY_HEAVY) {
                            ?>
                            <th>Heavy Items</th>
                            <?php
                        }
                        ?>
                        <th>Min Price</th>
                        <th>Max Price</th>
                        <th>Cost</th>
                        <?php
                        if (defined('ITEM_COMBINED_SHIPPING_ENABLED') && (int)ITEM_COMBINED_SHIPPING_ENABLED === 1) {
                            ?>
                            <th>Combined cost</th>
                            <?php
                        }
                        ?>
                        <th>Disable</th>
                        <?php
                            if (ADMIN_DELETE_DELIVERY_METHODS == true) {
                                ?>
                                <th class="center">Delete</th>
                                <?php
                            }
                        ?>
                    </tr>
                    <tbody class="tabular">
                    <?php
                    foreach ($deliveryMethods as $deliveryMethod) {
                        $data2 = $deliveryMethod->toArray();
                        $flag = !$flag;
                        if ($data2['band'] == 0) {
                            $data2['band'] = 'All';
                        }
                        ?>
                        <tr id="rorder-<?= $data2['id']; ?>">
                            <td><input type="text" name="name[<?= $data2['id']; ?>]" value="<?= clean_page($data2['name']); ?>" style="width:90%" /></td>
                            <?php
                                if (DELIVERY_HEAVY) {
                                    ?>
                                <td><?php if ($data2['heavy'] == 1) {
                                        ?>Yes<?php
                                    } else {
                                        ?>No<?php
                                    }
                                    ?></td>
                                <?php
                                }
                            ?>
                                <td><input type="text" name="min[<?= $data2['id']; ?>]" value="<?= clean_page($data2['min']); ?>" style=" width:100px;"/></td>
                                <td><input type="text" name="max[<?= $data2['id']; ?>]" value="<?= clean_page($data2['max']); ?>" style=" width:100px;"/></td>
                                <td><input type="text" name="cost[<?= $data2['id']; ?>]" value="<?= number_format(clean_page($data2['cost']), 2); ?>" style=" width:100px;"/></td>
                                <?php
                                if (defined('ITEM_COMBINED_SHIPPING_ENABLED') && (int)ITEM_COMBINED_SHIPPING_ENABLED === 1) { ?>
                                    <td><input type="text" name="item_combined_cost[<?= $data2['id']; ?>]"
                                               value="<?= number_format(clean_page($data2['item_combined_cost']), 2); ?>"
                                               style=" width:100px;"/></td>
                                    <?php
                                }
                                ?>
                                <td>
                                    <input type="hidden" name="disable[<?= $data2['id']; ?>]" value="0"/>
                                    <input type="checkbox" name="disable[<?= $data2['id']; ?>]"
                                           <?php if ($data2['disable']) {
                                           ?>checked<?php
                                    }
                                    ?> /></td>
                                <?php
                                    if (ADMIN_DELETE_DELIVERY_METHODS == true) {
                                        ?>
                                        <td class="center">
                                            <a href="manage.delivery.php?action=delete&delete_id=<?= $data2['id'] ?>"
                                               class="alert error"
                                               title="Are you sure you want to delete this delivery?">
                                                <i class="fa fa-times-circle"></i>
                                            </a>
                                        </td>
                                    <?php
                                    }
                                ?>
                            </tr>

                        <?php

                    }
                    ?>
                    </tbody>
                </table>
                <p>
                    <input type="hidden" name="action" value="update"/>
                    <input type="submit" value="Save"/>
                </p>
            </form>
            <?php

        }
    }
} else {
    ?>
    <p>There were no delivery methods found</p>
    <?php
}

require_once $path . 'core/admin/templates/adminfooter.html.php';
