<?php

use Mtc\Shop\Admin\ViewHelper;

?>
<tr id="rorder-<?= $order->getId() ?>"<?php if($order->flag > 0){ ?> class="list-<?= ViewHelper::$flags[$order->flag]; ?>"<?php } ?>>
    <td>
        <?= $order->getOrderDate(); ?>
    </td>
    <?php
    if (!$included) {
        ?>
        <td<?php if($included == true){ ?> style="padding:10px 0;"<?php } ?>>
            <div>
                <b><?= $order->order_ref; ?></b> by
                <?= $order->address['billing']['firstname'] . ' ' . $order->address['billing']['lastname'] . ' (' . $order->address['billing']['gender'] . ')'; ?>
                <?php
                if ($order->id_check_confirmed) {
                    ?>
                    <span class='orderVerified' title="<?= $order->id_check_confirmed == 2 ? 'ID Check confirmed on previous order' : 'ID check confirmed' ?>">
                                                <i class='fa fa-check-circle<?= $order->id_check_confirmed == 2 ? '-o' : '' ?>'></i>
                                            </span>
                    <?php
                }
                ?>
                <a href="manage.order.doctor.php?id=<?= $order->getId() ?>&tab=2" class="actionsIcon mtcOverlay">
                    <i class="fa fa-list-alt"></i>
                </a>
            </div>
        </td>
        <td>
            <div>
                <?php echo $order->info['email']; ?>
            </div>
        </td>
        <?php
    } else {
        ?>
        <td>
            <b><?= $order->order_ref; ?></b> by
            <?= $order->address['billing']['firstname'] . ' ' . $order->address['billing']['lastname'] . ' (' . $order->address['billing']['gender'] . ')'; ?>
        </td>
        <td>
            <?php
            $i = 1;
            foreach ($order->getItems() as $k => $line) {
                echo $i . '. ' . clean_page($line['item_name']) . ($line['size'] !== 'One Size' ? ' -  ' . strip_tags($line['size'], '<br>') : '') .  '<br />';
                ++$i;
            }
            ?>
        </td>
        <?php
    }
    ?>

    <td class="nowrap">

        <a href="manage.order.doctor.php?id=<?= $order->getId() ?><?= $load_all_items ? '&load_all_items=1' : ''; ?>" class="actionsIcon mtcOverlay">
            <i class="fa fa-eye"></i>
        </a>

        <?php if ($order->message_id) { ?>
            <?php $msg_data = $order->eloquent()->getMessageThreadsData() ?>
            <a href="/plugins/MembersMessaging/admin/view_member_thread.php?url=<?= $msg_data['thread']->url ?>" title="View Messages">
                <i class="fa fa-envelope<?php echo $msg_data['has_unread_messages'] ? '' : '-o'; ?>"></i>
            </a>
        <?php } ?>
    </td>

    <td<?php if($included == true){ ?> style="padding:10px 0;"<?php } ?>>
        <p>
            <?php
            $colorCoding = [
                0 => 'rgb(196, 218, 255)',
                1 => 'rgb(37, 127, 124)',
                2 => 'rgb(206, 0, 0)',
                3 => 'rgb(0, 170, 85)',
                11 => 'rgb(37, 127, 124)',
                13 => 'rgb(255, 127, 80)',
            ];
            ?>
            <span class="label" style="background-color: <?php echo $colorCoding[$order->status] ?? '#999999' ?>; color:#fff; padding:5px 10px;">
                <?php echo $orders_statuses[$order->status]; ?>
            </span>
        </p>
    </td>
</tr>
