<?php

use Mtc\Core\Permissions;
use Mtc\Plugins\DeliveryCouriers\Classes\Courier;
use Mtc\Shop\Admin\ViewHelper;
use Mtc\Shop\Order\Item as OrderItem;
use App\Admin\OrdersHelper;
use Mtc\Shop\Order\Shipment;


$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

init_request_values([
    'startnumber' => null,
    'category' => null,
    'status' => null,
    'coupon' => null,
    'id' => null,
    'postcode' => null,
    'firstname' => null,
    'lastname' => null,
    'email' => null,
    'start_date' => null,
    'end_date' => null,
    'type' => null,
    'trustpilot_status' => null,
    'orderbyfield' => null,
    'orderbydir' => null,
    'order_type' => null,
]);

$view_state_keys = ViewHelper::$view_state_keys;

$append = '';

$admin = \Mtc\Core\Admin\User::find($adminuser->user['id']);
$allowed_categories = $admin->allowedCategories->pluck('category_id');

$page_meta['title'] = 'Manage Orders';

$queryParams = $_REQUEST;

$type = $order_filter_type = filter_input(INPUT_GET, 'order_type');
$per_page = (filter_input(INPUT_GET, 'per_page') ?? 20);
if ($per_page > 250) {
    $per_page = 250;
}
if (!$per_page) {
    $per_page = 20;
}
$queryParams['per_page'] = $per_page;

$errors = [];
$warnings = [];

$startnumber = 0;
if (is_numeric($_REQUEST['startnumber'])) {
    $startnumber = $_REQUEST['startnumber'];
}


// Mark Orders as shipped
if (filter_input(INPUT_POST, 'processing_action') === 'ship' && !empty($_POST['process_orders'])) {
    foreach (array_keys($_POST['process_orders']) as $id) {
        // Confirm order exists
        if (Mtc\Shop\Order::where('id', $id)->count() == 0) {
            continue;
        }

        $order = new Order($id);
        if ($order->status === \Mtc\Shop\Order::STATUS_SHIPPED) {
            // If order already shipped, skip over it
            continue;
        }
        $order->updateStatus(\Mtc\Shop\Order::STATUS_SHIPPED);

        // Create shipment
        Shipment::create([
            'order_id' => $order->getId(),
            'date' => date('Y-m-d')
        ]);
    }
    header('Refresh: 0');
    exit();
}

if (filter_input(INPUT_POST, 'bulk_status_change') !== '' && !empty($_POST['process_orders'])) {
    $new_status = (int)filter_input(INPUT_POST, 'bulk_status_change');
    $order_ids = array_keys($_POST['process_orders']);
    foreach ($order_ids as $id) {

        if (Mtc\Shop\Order::where('id', $id)->count() === 0) {
            continue;
        }

        $order = new Order($id);
        $order->updateStatus($new_status);
    }
    header('Refresh: 0');
    exit();
}

// Generate parcelforce export for selected orders
if (filter_input(INPUT_POST, 'processing_action') === 'parcelforce' && !empty($_POST['process_orders'])) {
    $order_ids = array_keys($_POST['process_orders']);
    $courier = new ParcelForce();
    $courier->generateExport($order_ids);
    exit();
}

// Print dispatch notes for selected orders
if (filter_input(INPUT_POST, 'processing_action') === 'dispatch_notes' && !empty($_POST['process_orders'])) {
    $order_ids = array_keys($_POST['process_orders']);
    $url = '/shop/admin/orders/order.printorder.php?id=' . implode(',', $order_ids);
    header("Location: " . $url);
    exit();
}

// Print prescriptions for selected orders
if (filter_input(INPUT_POST, 'processing_action') === 'print_prescriptions' && !empty($_POST['process_orders'])) {

    header("Content-type:application/pdf");
    echo Order::batchPrescriptions(array_keys($_POST['process_orders']), $basket_countries, $twig);
    exit();
}

if (filter_input(INPUT_POST, 'processing_action') === 'print_pharmacy_labels' && !empty($_POST['process_orders'])) {
    $order_ids = array_keys($_POST['process_orders']);
    $url = "/shop/admin/orders/optimized_print.php?order_ids=" . implode(',', $order_ids);
    header("Location: " . $url);
    exit();
}

if (filter_input(INPUT_POST, 'processing_action') === 'capture_payments' && !empty($_POST['process_orders'])) {
    require_once SITE_PATH . '/shop/checkout/server/function.sagepay.php';
    \Mtc\Shop\Order\Protx::bulkCapturePayments(array_keys($_POST['process_orders']), $strReleaseURL);
    header('Refresh: 0');
    exit();
}

// Print invoices for selected orders
if (filter_input(INPUT_POST, 'processing_action') === 'print_invoices' && !empty($_POST['process_orders'])) {

    //header("Content-type:application/pdf");
    echo Order::batchInvoices(array_keys($_POST['process_orders']), $basket_countries, $twig);
    exit();
}

// Print optimized labels for selected orders
if (filter_input(INPUT_POST, 'processing_action') === 'optimized_labels' && !empty($_POST['process_orders'])) {
    $order_ids = implode(',', array_keys($_POST['process_orders']));
    header('Location: optimized_print.php?order_ids=' . $order_ids);
    exit();
}

// Bulk create shipments
if (filter_input(INPUT_POST, 'processing_action') === 'create_shipments' && !empty($_POST['process_orders'])) {
    $order_ids = array_keys($_POST['process_orders']);
    foreach ($order_ids as $order_id) {
        $order_to_ship = new Order($order_id);
        if ($order_to_ship->hasShipmentsWithLabels() === false) {
            // If there's a shipment but it doesn't have a label, we delete it and try create a new one
            if ($order_to_ship->hasShipments()) {
                Shipment::query()
                    ->where('order_id', '=', $order_id)
                    ->delete();
            }
            Courier::sendOrder($order_to_ship);
        }
    }
    header('Refresh: 0');
    exit();
}

// Trustpilot mass action
if (filter_input(INPUT_POST, 'processing_action') === 'trustpilot' && !empty($_POST['process_orders'])) {
    Order::batchTrustpilot($_POST['process_orders']);
    header("Refresh: 0");
    exit();
}

if (filter_input(INPUT_POST, 'processing_action') === 'bulk_print_consent') {
    Order::batchConsentFiles(array_keys($_POST['process_orders']));
    exit;
}

$orderbyfield = 'order.id';
$orderbydir = 'DESC';
$orderbydiropp = 'ASC';

if (!empty($_REQUEST['orderbyfield']) && !empty($_REQUEST['orderbydir'])) {
    $orderbyfield = str_replace('-', '.', $_REQUEST['orderbyfield']);
    $orderbydir = $_REQUEST['orderbydir'] === 'ASC' ?
        'ASC' :
        'DESC';
}

if (isset($queryParams['page'])) {
    unset($queryParams['page']);
}
$append = '&' . http_build_query($queryParams);

$orderbydiropp = $_REQUEST['orderbydir'] === 'ASC' ?
    'DESC' :
    'ASC';

$orderByField = $orderbyfield === 'item' ?
    '`order_items`.`item_name`' :
    $orderbyfield;


// If the user is doctor and the status is not one of the processing statuses, need to limit the results
$limit = '';

if (empty($_GET['page'])) {
    $_GET['page'] = 1;
}

$rowsPerPage = (int)$per_page;
$pageNum = $_GET['page'];
$offset = ($pageNum - 1) * $rowsPerPage;
$pagestoshow = 10;

$orderHelper = new OrdersHelper($_REQUEST);
$builderQuery = $orderHelper->getOrdersBuilderQuery(filter_input(INPUT_GET, 'order_type'));

$totalnumrows = $builderQuery->get()
    ->count();

$orderData = $builderQuery
    ->orderBy($orderByField, $orderbydir)
    ->orderByDesc('order.id')
    ->take($rowsPerPage)
    ->offset($offset)
    ->get();

require_once $path . 'core/admin/templates/adminheader.html.php';
?>

    <ul class="breadcrumbs el">
        <li><a href="/admin/">Home</a> /</li>
        <li class="end">Orders</li>
    </ul>

    <h1>Orders</h1>

<?php

include __DIR__ . '/tabnav.php';

if (!empty($errors)) {
    showerrors($errors);
}
if (!empty($warnings)) {
    showerrors($warnings, 'alert');
}

if (!empty($_SESSION['error'])) {
    echo showmsg($_SESSION['error'], 'error', $path);
    unset($_SESSION['error']);
}

if (!empty($_SESSION['message'])) {
    echo showmsg($_SESSION['message'], 'success', $path);
    unset($_SESSION['message']);
}

include_once __DIR__ . '/templates/manage_orders_filter.php';

if ($totalnumrows > 0) {
    ?>
    <form action="<?= \Util::add_query_arg([]) ?>" method="post" id="orderBulkActionForm">

        <div class="row alignRight">
            <div class="row">
                <strong>Orders Found:</strong>
                <?= $totalnumrows ?>
            </div>

            <?php
            include($path . 'core/admin/templates/per_page.php');
            include($path . 'core/admin/templates/pagination.php');

            foreach ($_GET as $key => $value) {
                if (in_array($key, ViewHelper::$view_state_keys) && $value !== '') {
                    ?>
                    <input type="hidden" name="<?= clean_page($key) ?>" value="<?= clean_page($value) ?>"/>
                    <?php
                }
            }
            ?>

            <?php if (Permissions::can(Permissions::DO_BULK_ORDER_ACTIONS)) { ?>
                <div class="right">
                    <input name="workstation_number" type="number" placeholder="Workstation number" width="100" />
                    <select name="processing_action"
                            class="INPUT1"
                            id="processing_action"
                    >
                        <option value="0">--- ACTION ---</option>
                        <option value="ship">Mark Shipped</option>
                        <option value="create_shipments">Create Shipments</option>
                        <option value="print_prescriptions" data-new-window="true">Print Prescriptions</option>
                        <option value="print_invoices" data-new-window="true">Print Invoices</option>
                        <option value="print_pharmacy_labels" data-new-window="true">Print Pharmacy Labels</option>
                        <?php
                        if (Permissions::can(Permissions::REVIEW_NHS_ORDERS)) {
                            ?>
                            <option value="bulk_print_consent" data-new-window="true">Bulk Print NHS Consent</option>
                            <?php
                        }
                        ?>
                        <?php
                        if (defined("TRUSTPILOT_API_ENABLED") && TRUSTPILOT_API_ENABLED) {
                            ?>
                            <option value="trustpilot">Send Trustpilot invitations</option>
                            <?php
                        }
                        ?>
                    </select>
                    <select name="bulk_status_change"
                            class="INPUT1"
                            id="bulk_status_change">
                        <option value="">--- STATUS ---</option>
                        <?php
                        foreach (\Mtc\Shop\Order::$statuses as $key => $status) {
                            echo "<option value='{$key}'>{$status}</option>";
                        }
                        ?>
                    </select>

                    <input name="action" type="submit" value="Submit"/>
                </div>
            <?php } ?>
        </div>

        <table class="manage-items">
            <?php


            if (Permissions::can(Permissions::DOCTOR_ORDER_VIEW)) {
                ViewHelper::getHeaderRow('doctor');
            } elseif (Permissions::can(Permissions::PHARMACIST_ORDER_VIEW)) {
                ViewHelper::getHeaderRow('pharmacist');
            } else {
                ViewHelper::printCheckboxRow();
                if (Permissions::can(Permissions::REVIEW_NHS_ORDERS)) {
                    ViewHelper::getHeaderRow('nhs_user');
                } else {
                    ViewHelper::getHeaderRow('manager');
                }
            }
            ?>
            <tbody class="tabular">
            <?php
            $flags = [
                1 => 'brown',
                2 => 'black',
            ];

            $orders_to_review = [];

            foreach ($orderData as $k => $data) {
                $order = new Order();
                $order->build($data->toArray());
                $order->ordered_within_four_weeks = $data['ordered_within_four_weeks'];

                if (Permissions::can(Permissions::DOCTOR_ORDER_VIEW)) {
                    ViewHelper::getDataRow('doctor', $order);
                } elseif (Permissions::can(Permissions::PHARMACIST_ORDER_VIEW)) {
                    ViewHelper::getDataRow('pharmacist', $order);
                } else {
                    if (Permissions::can(Permissions::REVIEW_NHS_ORDERS)) {
                        ViewHelper::getDataRow('nhs_user', $order);
                    } else {
                        ViewHelper::getDataRow('manager', $order);
                    }
                }

                if (!Permissions::isReviewer()) {
                    continue;
                }

                foreach ($order->getItems() as $order_line) {
                    $item = new Item();
                    $item->Get_Item($order_line['item_id']);
                    /** @var OrderItem $orderItem */
                    $orderItem = OrderItem::query()
                        ->find($order_line['id']);
                    $item_eloquent = $item->eloquent();

                    if ($item_eloquent === null) {
                        continue;
                    }
                    // User has no access right to approve
                    if (!OrderItem::orderItemCanBeApproved($orderItem)) {
                        continue;
                    }

                    // Already reviewed by doctor
                    if (Permissions::can(Permissions::REVIEW_DOCTOR_ORDERS) && (int)$order_line['approved'] !== 0) {
                        continue;
                    }

                    if (Permissions::can(Permissions::REVIEW_PHARMACY_ORDERS)) {
                        // Already clinically checked by pharmacist
                        if ($orderItem->clinic_checked) {
                            continue;
                        }

                        if ($item_eloquent->product_type === \Mtc\Shop\Item::TYPE_PHARMACY) {
                            // Can only review pharmacy products that haven't been reviewed
                            if ((int)$orderItem->approved !== 0) {
                                continue;
                            }
                        } elseif ($item_eloquent->product_type === \Mtc\Shop\Item::TYPE_DOCTOR) {
                            // Can only review doctor products that have been reviewed by doctor
                            if ((int)$orderItem->approved !== 1) {
                                continue;
                            }
                        }
                    }
                    $orders_to_review[] = $order->getId();
                    break;
                }

            }

            ?>
            </tbody>
        </table>
    </form>
    <?php
    if (!empty($orders_to_review)) {
        ?>
        <input type="hidden" id="ordersToReview" value="<?= implode(',', $orders_to_review); ?>"/>
        <?php
    }

    include($path . 'core/admin/templates/per_page.php');
    ?>
    <div class="row" style="margin-top: 20px;">
        <?php
        include($path . 'core/admin/templates/pagination.php');
        ?>
    </div>
    <?php

} else {
    ?>
    <p>There were no orders found matching your search criteria</p>
    <?php
}

if (EXPORT_ORDERS === true && Permissions::can(Permissions::DO_BULK_ORDER_ACTIONS)) {
    ?>
    <form action="export.orders.php?<?= http_build_query($_GET); ?>" method="post" enctype="multipart/form-data" class="style">
        <h2>Export Orders</h2>
        <p>Click export below to export the above orders as a CSV</p>

        <div class="row">
            <input type="submit" value="Export"/>
        </div>
    </form>
    <?php
    if (!empty($_SESSION['adminId']) && $_SESSION['adminId'] == 1) {
        ?>
        <form action="export.orders.php?anonymised=1&<?= http_build_query($_GET); ?>" method="post" enctype="multipart/form-data" class="style">
            <h2>Export Anonymised Order Data</h2>
            <p>Click export below to export the above orders as a CSV</p>

            <div class="row">
                <input type="submit" value="Export"/>
            </div>
        </form>
        <?php
    }
}
if (Permissions::can(Permissions::EXPORT_ELECTRONIC_PRIVATE_REGISTER)) {
    ?>
    <form action="export.orders.doctor.php" method="post" class="style">
        <h2>Export Electronic Private Register</h2>
        <p>This will export a CSV containing records of all 'Doctor Items' dispensed within the specificed date.</p>
        <input type="hidden" name="start_date" value="<?= clean_page($_REQUEST['start_date']); ?>"/>
        <input type="hidden" name="end_date" value="<?= clean_page($_REQUEST['end_date']); ?>"/>
        <div class="row">
            <input type="submit" value="Export"/>
        </div>
    </form>
    <?php
}
require_once $path . 'core/admin/templates/adminfooter.html.php';
