<?php

use Mtc\Shop\PropertyType;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

init_request_values([
    'id' => null,
    'page' => null,
]);

$property_type_id = null;
$errors = [];

if ($_REQUEST['id'] > 0) {
    $addedit = 'Update';
    $property_type_id = abs((int)clean_page($_REQUEST['id']));
} else {
    $addedit = 'Add';
}

$page_meta['title'] = $addedit . ' Property Value';

$property_id = $_REQUEST['propertyid'];

$propertyType = PropertyType::query()
    ->find($property_id);

$display_form = true;

/*
 * Add A New Property
 */
if ($_REQUEST['action'] == 'updateproperty') {

    // remove all special characters
    $property_name = trim(preg_replace('/[^A-Za-z0-9\-\s]/', '', $_REQUEST['property_name']));

    if (empty($property_name)) {
        $errors['property_name'] = 'You must enter a ' . $propertyType->name . ' name';
    }

    if (sizeof($errors) == 0) {

        $params = [
            ':property_name' => $property_name,
            ':property_type_id' => $property_id,
        ];

        if ($property_type_id > 0) {
            \Mtc\Shop\Property::query()
                ->where('id', $property_type_id)
                ->update([
                    'name' => $property_name,
                    'property_type_id' => $property_id,
                ]);

            header('Location: manage.property_values.php?propertyid=' . $propertyType->id . '&message=update&page=' . $_REQUEST['page']);


        }

        \Mtc\Shop\Property::query()
            ->create([
                'name' => $property_name,
                'property_type_id' => $property_id,
            ]);

        header('Location: manage.property_values.php?propertyid=' . $propertyType->id . '&message=added&page=' . $_REQUEST['page']);
        exit();

    }
}

require_once $path . 'core/admin/templates/adminheader.html.php';

?>
<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>

    <li><a href="manage.properties.php">Manage Item Properties</a> /</li>

    <li class="end"><?= $addedit ?> <?= clean_page($propertyType->name) ?></li>
</ul>

<h1><?= $addedit ?> <?= clean_page($propertyType->name) ?></h1>

<?php
include 'valuetabnav.php';

if (isset($updated)) {

    if (sizeof($errors) == 0 && isset($_REQUEST['action'])) {
        echo showmsg("Property updated", "success", $path);
    }

}

if (!empty($errors)) {
    showerrors($errors);
}

if ($display_form === true) {

    $property = \Mtc\Shop\Property::query()
        ->find($property_type_id);
    ?>

    <form action="edit.property_values.php" method="POST" enctype="multipart/form-data" class="style">
        <fieldset class="show">
            <h1>
                <a class="show el">
                    <?= clean_page($propertyType->name) ?> Information <i class="fa fa-caret-right"></i>
                </a>
            </h1>

            <div class="row">
                <label for="property_name">Name</label>
                <input type="text" name="property_name" id="property_name" value="<?= ($property->name ?? null) ?>" class="INPUT1">
            </div>
        </fieldset>

        <input type="hidden" name="action" value="updateproperty"/>
        <input type="hidden" name="id" value="<?= $property_type_id ?>" />
        <input type="hidden" name="page" value="<?= clean_page($_REQUEST['page']) ?>" />
        <input type="hidden" name="propertyid" value="<?= $propertyType->id ?>" />

        <div class="row">
            <input type="submit" value="Save" />
        </div>

    </form>

<?php
}

require_once $path . 'core/admin/templates/adminfooter.html.php';
