<?php

use Mtc\Shop\Vat;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

$page_meta['title'] = 'Manage VAT Rates';
$errors = [];

/*
    Delete The Brand
*/
if ($_REQUEST['action']=='delete' && is_numeric($_REQUEST['delete_id'])) {
    Vat::query()
        ->where('id', $_REQUEST['delete_id'])
        ->delete();
}

require_once $path . 'core/admin/templates/adminheader.html.php';

?>
<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>

    <li class="end">VAT Rates</li>
</ul>

<h1>VAT Rates</h1>
<?php

include 'tabnav.php';

if (sizeof($errors)>0) { showerrors($errors); }

$vats = Vat::query()
    ->orderBy('name')
    ->get();

if ($vats->count() > 0) {
    ?>
    <form action="<?= $_SERVER['PHP_SELF'];?>" method="post">
        <table class="manage-items half">
            <tr>
                <th>Rate</th>
                <th class="center">Delete</th>
            </tr>
            <tbody class="tabular">
            <?php
            foreach ($vats as $vat) {
                $data = $vat->toArray();
                ?>
                <tr id="rorder-<?= $data['id'];?>">
                    <td><?php echo $data['name'];?>%</td>
                    <td class="center"><a href="manage.vat.php?action=delete&delete_id=<?php echo $data['id'];?>" class="alert picto error" title="Are you sure you want to delete the VAT rate?"><i class="fa fa-times-circle"></i></a></td>
                </tr>
                <?php
            }
            ?>
            </tbody>
        </table>
        <input type="hidden" name="action" value="update">
    </form>
    <?php
} else {
    ?>
    <p>No VAT rates have been created</p>
    <?php
}

require_once $path . 'core/admin/templates/adminfooter.html.php';
