<?php
use Stripe\Stripe;

//Get secrect and publishable keys depending on configuration
if (defined('STRIPE_MTC_TEST') && STRIPE_MTC_TEST === true) {
    $secret_key = STRIPE_MTC_SECRET_KEY;
    $publishable_key = STRIPE_MTC_PUBLISHABLE_KEY;
} else {
    if (defined('STRIPE_LIVE') && STRIPE_LIVE === true) {
        $secret_key = STRIPE_SECRET_KEY;
        $publishable_key = STRIPE_PUBLISHABLE_KEY;
    } else {
        $secret_key = STRIPE_TEST_SECRET_KEY;
        $publishable_key = STRIPE_TEST_PUBLISHABLE_KEY;
    }
}

//Array with keys
$stripe_config = array(
  "secret_key"      => $secret_key,
  "publishable_key" => $publishable_key
);

//Set Api Key with Stripe library
Stripe::setApiKey($stripe_config['secret_key']);
