<?php
/**
 * Basket Object Eloquent model
 *
 * @version 11/10/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Shop;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Mtc\Modules\Members\Models\Member;
use MtcPharmacy\Subscriptions\Classes\Subscription;

/**
 * Basket Object Eloquent model.
 * Implements Shop basket basic functionality
 *
 * @version 11/10/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 *
 */
class Basket extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'basket';

    /**
     * @var array The attributes that are mass assignable.
     */
    protected $fillable = [
        'date',
        'delivery',
        'billing_address_used',
        'coupon',
        'member',
        'ref',
        'keywords',
        'basket_expiry_time',
        'checkout',
        'seccode'
    ];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * Define the relationship to basket items
     * @return HasMany
     */
    public function items()
    {
        return $this->hasMany(Basket\Item::class, 'basket_id');
    }

    /**
     * Define the relationship to basket info
     * @return HasOne
     */
    public function info()
    {
        return $this->hasOne(Basket\Info::class, 'basket_id');
    }

    /**
     * Define the relationship to basket addresses
     * @return HasMany
     */
    public function address()
    {
        return $this->hasMany(Basket\Address::class, 'basket_id');
    }
    /**
     * Define the relationship to basket addresses
     * @return HasOne
     */
    public function billingAddress()
    {
        return $this->hasOne(Basket\Address::class, 'basket_id')
            ->where('type', 'billing');
    }
    /**
     * Define the relationship to basket addresses
     * @return HasOne
     */
    public function shippingAddress()
    {
        return $this->hasOne(Basket\Address::class, 'basket_id')
            ->where('type', 'shipping');
    }


    public function customer()
    {
        return $this->belongsTo(Member::class, 'member', 'id');
    }


    public function subscription()
    {
        return $this->belongsTo(Subscription::class);
    }


    public function legacy($skip_zones_and_limits = true)
    {
        $basket = new \Basket($this->id);
        $basket->Go_Basket($skip_zones_and_limits);

        return $basket;
    }
}
