<?php
/**
 * Basket Info Object Eloquent model.
 * @version 13/10/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Basket;

use Illuminate\Database\Eloquent\Model;

/**
 * Basket Info Object Eloquent model.
 * Implements functionality for managing Shop Basket Customer Info
 *
 * @version 13/10/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class Info extends Model
{
    // Use trait that defines relationship to basket
    use BelongsToBasket;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'basket_info';

    /**
     * @var array The attributes that are mass assignable.
     */
    protected $fillable = [
        'basket_id',
        'email',
        'phone_prefix',
        'contact_no',
        'mobile_no',
        'message',
        'newsletter',
        'how_did_you_hear_about_us',
        'dob_date',
        'dob_month',
        'dob_year',
        'multisite__site_id',
        'assessment_ids'
    ];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;
}
