<?php
/**
 * Custom Field Set Field Eloquent model
 *
 * @version 29/09/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Shop;

use Illuminate\Database\Eloquent\Model;

/**
 * Custom Field Set Field Eloquent model.
 * Defines the model for Custom field assignments to a set
 *
 * @version 29/09/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class CustomFieldSetField extends Model
{

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'custom_fields_sets_fields';

    /**
     * @var array The attributes that are mass assignable.
     */
    protected $fillable = [
        'set_id',
        'custom_field_id',
        'required',
        'items',
        'variations',
        'filter',
        'order'
    ];

    /**
     * Define relationship to the custom field
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function field()
    {
        return $this->belongsTo(CustomField::class, 'custom_field_id');
    }

    /**
     * Define relationship to the custom field set
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function set()
    {
        return $this->belongsTo(CustomFieldSet::class, 'set_id');
    }

}