<?php
namespace Mtc\Shop;

use Illuminate\Database\Eloquent\Model;
use Mtc\Shop\Item\Size;

/**
 * @author Uldis Zvirbulis <uldis.zvirbulis@mtcmedia.co.uk>
 */
class DeliveryZone extends Model
{
    protected $fillable = [
        'country_code',
        'country_name',
        'zone',
        'disable',
    ];

    /**
     * Define the relationship to Restricted categories
     * @return \Illuminate\Database\Eloquent\Relations\belongsToMany
     */
    public function restricted_categories()
    {
        return $this->belongsToMany(Category::class, 'category_restricted_zones');
    }

}
