<?php
namespace Mtc\Shop\Events;

use Basket;
use Member;
use Item;
/**
 * Class AddToBasketEvent
 *
 * This is an event class. Used to fire and handle an "Add To Basket".
 * An instance of this class is passed to event handlers that subscribe to this event.
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 * @version 2016-09-18
 */
class AddToBasketEvent
{
    /**
     * @var Basket
     */
    protected $basket;
    /**
     * @var Member
     */
    protected $member;
    /**
     * @var Item
     */
    protected $item;
    /**
     * @var array
     */
    protected $params;
    /**
     * @var array
     */
    protected $request;

    /**
     * @return Basket
     */
    public function getBasket()
    {
        return $this->basket;
    }

    /**
     * @return Member
     */
    public function getMember()
    {
        return $this->member;
    }

    /**
     * @return Item
     */
    public function getItem()
    {
        return $this->item;
    }

    /**
     * @return array
     */
    public function getParams()
    {
        return $this->params;
    }

    /**
     * @return array
     */
    public function getRequest()
    {
        return $this->request;
    }

    /**
     * @param Basket $basket Basket to which item is being added
     * @param Member|null $member Current Member or null if members disabled
     * @param Item $item item that added to basket
     * @param array $params compiled params from add to basket script
     * @param array $request $_REQUEST values
     */
    public function __construct(Basket $basket, $member, Item $item, $params, $request)
    {
        $this->item = $item;
        $this->basket = $basket;
        $this->params = $params;
        $this->member = $member;
        $this->request = $request;
    }
}