<?php

namespace Mtc\Shop\Events;

use Basket;

/**
 * Class BasketAlternateDeliveryCheckEvent
 *
 * This is an event class.
 * This event is called in Basket initialization
 * An instance of this class is passed to event handlers that subscribe to this event.
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk
 * @version 2016-08-20
 */
class BasketAlternateDeliveryCheckEvent
{
    /**
     * @var \Order
     */
    protected $basket;


    /**
     * @return Basket
     */
    public function getBasket()
    {
        return $this->basket;
    }

    /**
     * @param Basket $basket Current Basket
     */
    public function __construct(Basket $basket)
    {
        $this->basket = $basket;
    }
}
