<?php

namespace Mtc\Shop\Events;

/**
 * Class BasketGetItemsEvent
 *
 * This is an event class. Used to fire and handle an "Order Get Items".
 * An instance of this class is passed to event handlers that subscribe to this event.
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk
 * @version 2016-05-30
 */
class BasketGetItemsEvent
{
    /**
     * @var \Order
     */
    protected $basket;


    protected $item;

    /**
     * @return \Basket
     */
    public function getBasket()
    {
        return $this->basket;
    }

    /**
     * @return string[]
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * @param \Order $order Order that is loaded
     * @param string[] $order_item
     */
    public function __construct($basket_item, \Basket $basket)
    {
        $this->basket = $basket;
        $this->item = $basket_item;
    }
}
