<?php

namespace Mtc\Shop\Events;

use ProductFilter;

/**
 * Generate URL event, triggered at the end of ProductFilter::generateURL()
 *
 * @author Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class FilterGenerateUrl
{
    /**
     * Store the full selections from the filter.
     *
     * @var array
     */
    public $selections_all = [];

    /**
     * Store the URL generated by the filter. As this is passed by reference,
     * we can override this with event listeners if required.
     *
     * @var string
     */
    public $url = '';

    /**
     * Initiate the event, storing the filter's selections and generated URL.
     *
     * @param array  $selections_all Selections as defined in filter.
     * @param string &$url           The URL generated by generateURL method.
     *
     * @return void
     */
    public function __construct(array $selections_all, &$url)
    {
        $this->selections_all = $selections_all;
        $this->url = &$url;
    }
}
