<?php

namespace Mtc\Shop\Events;

/**
 * Class OrderStatusChangedEvent
 *
 * This is an event class. Used to fire and handle an "Order Status Changed".
 * An instance of this class is passed to event handlers that subscribe to this event.
 *
 * @author Haroldas Latonas <haroldas.latonas@mtcmedia.co.uk
 * @version 2017-10-16
 */
class OrderStatusChangedEvent
{
    /**
     * @var \Order
     */
    protected $order;

    /**
     * @var string
     */
    protected $status;

    /**
     * @return \Order
     */
    public function getOrder()
    {
        return $this->order;
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param \Order $order Order that is loaded
     * @param $status
     */
    public function __construct(\Order $order, $status)
    {
        $this->order = $order;
        $this->status = $status;
    }
}
