<?php
/**
 * BelongsToOrder Trait.
 * @version 20/10/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Order;

use Mtc\Shop\Order;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * BelongsToOrder Trait.
 * Add ability to link any object to order via order_id column
 *
 * @version 20/10/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
trait BelongsToOrder
{
    /**
     * Scope - ofBasket()
     *
     * @param Builder $query Query to extend
     * @param Order $order
     * @return Builder
     */
    public function scopeOfOrder(Builder $query, $order)
    {
        return $query->where("order_id", id($order));
    }

    /**
     * Define Eloquent relationship to Order class
     * @return BelongsTo
     */
    public function order()
    {
        return $this->belongsTo(Order::class, 'order_id', 'id');
    }
}