<?php
/**
 * Order Note Object Eloquent model.
 *
 * @version 03/03/17
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Order;

use Illuminate\Database\Eloquent\Model;

/**
 * Order Note Object Eloquent model.
 *
 * Manages order_note table entries
 *
 * @version 27/10/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class Note extends Model
{
    // Use trait that defines relationship to order
    use BelongsToOrder;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'order_note';

    /**
     * @var array The attributes that are mass assignable.
     */
    protected $fillable = [
        'magento_entity_id',
        'order_id',
        'note'
    ];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

}
