<?php

namespace Mtc\Shop;
/**
 * PlaceholderImage Class
 *
 * Used for shop placehodler images editing and pulling through from database
 *
 * @author  Valdis Ceirans <valdis.ceirans@mtcmedia.co.uk>
 */
class PlaceholderImage extends \Illuminate\Database\Eloquent\Model
{
    /**
    * Get array with placeholder images where key is placeholder image type
    * @return array with placeholder images
    */
    public static function getPackedData() {
        $placeholder_data = self::get()->toArray();

        $placeholder_images = [];

        foreach ($placeholder_data as $image_data) {
            $placeholder_images[$image_data['name']] = $image_data;
        }

        return $placeholder_images;

    }
}
