<?php
/**
 * Class Language
 * 
 * Main multi-language class for cms2
 * 
 * @todo scope it. but how?
 */
class Language extends Illuminate\Database\Eloquent\Model {
    public $timestamps = false;
    public static $locale_path = LANGUAGE_LOCALE_PATH;
    public $dirs_that_dont_hold_templates = array('includes','vcs','admin','classes','css','images','.git','js','git','vendor','libs');

    public static function isIgnoredPage($page_id) {

        if ( CMS_MULTI_LANG_PAGE_IGNORE !== true ) {
            return false;
        }

        $ignore_json = CMS_MULTI_LANG_PAGE_IGNORE_JSON;  
        $ignore_array = json_decode($ignore_json, true);
        if ( empty($ignore_array) ) {
            return false;
        }

        $page_trail = Page::generate_trail($page_id);
        $array_trail = array();
        for ($i=0; $i < count($page_trail); $i++) { 
            $array_trail[] = $page_trail[$i]->id;
        }

        $array_trail = array_reverse($array_trail);

        $postfix = "";

        for ($i=0; $i < count($array_trail); $i++) { 

            if ( $i > 0 ) {
                $postfix = "/*";
            }

            if ( in_array($array_trail[$i].$postfix, $ignore_array) ) {
                return true;
            } else if ( in_array("!".$array_trail[$i].$postfix, $ignore_array) ) {
                return false;
            } 

        }

        if ( in_array("*", $ignore_array) ) {
            return true;
        }

        return false;
    }


    public function iterateThroughTemplates($directory) {
        // create an array to hold directory list
        $results = array();
        $dirs_that_dont_hold_templates = $this->dirs_that_dont_hold_templates;
        foreach(new DirectoryIterator($directory) as $file) {
            if ( (!$file->isDot()) && ($file->getFilename() != basename($_SERVER['PHP_SELF'])) ) {
                if($file->isDir()){
                    if($directory == SITE_PATH && in_array($file->getFilename(), $dirs_that_dont_hold_templates)){
                        continue;
                    }
                    $results = array_merge($results,  $this->iterateThroughTemplates($directory . '/' . $file->getFilename()));
                }else{
                    if($file->getExtension() == 'php' || $file->getExtension() === 'twig'){
                        $file_path = $directory . '/' .  $file->getFilename();
                        $results[] = $file_path;
                    }
                }
            }
        }
        return $results;
    }

    public static function getTranslatables($string) {

        $tokens = token_get_all($string);
        $count = count($tokens);
        $bufferFunctions = array();
        $functions = array();
        $translatables = new Gettext\Translations();

        for ($k = 0; $k < $count; $k++) {
            $value = $tokens[$k];

            //close the current function
            if (is_string($value)) {
                if ($value === ')' && isset($bufferFunctions[0])) {
                    $functions[] = array_shift($bufferFunctions);
                }

                continue;
            }

            //add an argument to the current function
            if (isset($bufferFunctions[0]) && ($value[0] === T_CONSTANT_ENCAPSED_STRING)) {
                $val = $value[1];

                if ($val[0] === '"') {
                    $val = str_replace('\\"', '"', $val);
                } else {
                    $val = str_replace("\\'", "'", $val);
                }

                $bufferFunctions[0][2][] = substr($val, 1, -1);
                continue;
            }

            //new function found
            if (($value[0] === T_STRING) && is_string($tokens[$k + 1]) && ($tokens[$k + 1] === '(')) {
                array_unshift($bufferFunctions, array($value[1], $value[2], array()));
                $k++;

                continue;
            }
        }

        foreach ($functions as $function) {
            list($name, $line, $args) = $function;
            switch ($name) {
                case '_':
                    if (!isset($args[0])) {
                        continue 2;
                    }
                    $original = $args[0];
                    $translation = $translatables->insert('', $original);
                    $translation->addReference($file, $line);
                    break;

                case '__':
                    if (!isset($args[0])) {
                        continue 2;
                    }
                    $original = $args[0];
                    $translation = $translatables->insert('', $original);
                    $translation->addReference($file, $line);
                    break;

                case 'n__':
                    if (!isset($args[1])) {
                        continue 2;
                    }
                    $original = $args[0];
                    $plural = $args[1];
                    $translation = $translatables->insert('', $original, $plural);
                    $translation->addReference($file, $line);
                    break;

                case 'gettext':
                    if (!isset($args[0])) {
                        continue 2;
                    }
                    $original = $args[0];
                    $translation = $translatables->insert('', $original);
                    $translation->addReference($file, $line);
                    break;

                case 'p__':
                    if (!isset($args[1])) {
                        continue 2;
                    }
                    $context = $args[0];
                    $original = $args[1];
                    $translation = $translatables->insert($context, $original);
                    $translation->addReference($file, $line);
                    break;
            }
        }
        return $translatables;
    }
}