<?php
use Illuminate\Support\Facades\Event;
use Mtc\Core\Permissions;

$path = '../../';
require_once $path . 'core/includes/header.inc.php';

$admin = (new \Mtc\Core\Admin\User())->find($adminuser->user['id']);
// Doctor should not be able to access the dashboard
if (Permissions::isReviewer()) {
    header('location: /shop/admin/orders/manage.orders.php?order_type=pending_review');
    exit;
}

$messages = [];
if (isset($_REQUEST['access']) && $_REQUEST['access'] === 'none') {
    // put up a 403 because the client would have landed here
    // with the above params set only if he was doing something forbidden
    // based on admin area auth so that ajax scripts can handle accordingly
    header("HTTP/1.0 403 Forbidden");
    $messages[] = [
        'type' => 'error',
        'content' => 'You do not have permission to view that page.'
    ];
}

$page_meta['title'] = "Dashboard";

if (!isset($_SESSION['adminId']) || $_SESSION['adminId'] == 0) {
    header('Location: /admin/login.php');
    exit();
}

// Prepare stats
$graphs = $numeric_stats = [];
if(ADVANCED_STATS_ENABLED === true || GRAPH_STATS_ENABLED === true) {
    $stats = collect(Event::dispatch('Admin::dashboardStats'))
        ->flatten(1);
    $graphs = $stats->where('type', 'graph');
    $numeric_stats = $stats->where('type', 'numeric');
}

// set default dates for stats dates
$start_date = date('d/m/Y', time());
if (filter_input(INPUT_GET, 'start_date')) {
    $start_date = filter_input(INPUT_GET, 'start_date');
}
$end_date = date('d/m/Y', time());
if (filter_input(INPUT_GET, 'end_date')) {
    $end_date = filter_input(INPUT_GET, 'end_date');
}

$twig->display('admin/index.twig', [
    'page_meta' => $page_meta,
    'messages' => $messages,
    'graphs' => $graphs,
    'numeric_stats' => $numeric_stats,
    'start_date' => $start_date,
    'end_date' => $end_date
]);
