<?php

use Mtc\Core\Models\CountryState;
use Mtc\Modules\Members\Models\Member;
use Mtc\Modules\Members\Models\MembersAddress;

$path = '../../../../';
require_once $path . 'core/includes/header.inc.php';

$state_list = CountryState::getCountryStateList();

//get the ID of the member to edit - no ID means user wants to add new member
if (isset($_REQUEST['id'])) {
    $member_id = (int) $_REQUEST['id'];
} else {
    $member_id = 0;
}

//will load member if ID given
$member = Member::findOrNew($member_id);
$address = $member->addressBilling ?: new MembersAddress();

if (!empty($_REQUEST['country']) && !empty($state_list[$_REQUEST['country']])) { ?>
    <label for="billing_state">State</label>
    <select name="billing_state" id="billing_state">
        <?php
        foreach ($state_list[$_REQUEST['country']] as $state_id => $state_name) {

            $selected = $address->state == $state_id ? 'selected' : '';
            ?>
            <option value="<?= $state_id ?>" <?= $selected ?>><?= clean_page($state_name) ?></option>
            <?php
        }
        ?>
    </select>
<?php
}