<?php

namespace Mtc\Plugins\Clinic\Http\Controllers\Admin;

use Illuminate\Http\JsonResponse;
use Mtc\Plugins\Wisebee\Classes\Models\WisebeeConsultation;

/**
 * Class ConsultationController
 */
class ConsultationController extends ClinicController
{

    /**
     * Load entries
     *
     * @param $id
     * @return JsonResponse
     */
    public function load($id): JsonResponse
    {
        return response()
            ->json([
                'consultations' => WisebeeConsultation::getMemberConsultations($id),
            ]);
    }
}
