Vue.component('patientFlags', {

    props: [
        'routes',
    ],

    data: function() {
        return {
            flags: [],
            loading: false,
            add: false,
            errors: {},
            success: false,
            display: 5,
            flag: '',
            isTask: false,
            deleteIndex: -1,
        };
    },

    mounted: function() {
        this.init();
    },

    methods: {
        init() {
            this.load();
        },
        load() {
            this.loading = true;
            let vm = this;

            this.$http.post(this.routes['admin-member-notes-load-flags'], [])
                .then((response) => {

                    const data = response.data;

                    vm.flags = data.flags;
                    vm.loading = false;
                });
        },
        addFlag() {
            this.add = true;
        },
        cancel() {
            this.add = false;
        },
        store() {
            if (this.loading) {
                return;
            }
            this.errors = {};
            this.success = false;
            this.loading = true;

            let vm = this;

            this.$http.post(this.routes['admin-member-notes-store'], {
                note: this.flag,
                isTask: this.isTask ? '1' : '0',
                flagDue: $('#flagDue').val(),
                isFlag: 1,
            })
                .then((response) => {

                    const data = response.data;

                    if (data.errors) {
                        vm.errors = data.errors;
                        this.loading = false;
                        return;
                    }
                    if (data.success) {
                        vm.success = data.success;
                    }
                    vm.flag = '';
                    vm.add = false;
                    vm.load();
                    vm.emitEvent('flagsChanged');
                });
        },
        showConfirmDeletion(index) {
            this.deleteIndex = index;
        },
        deleteFlag(id) {
            if (this.loading) {
                return;
            }
            this.errors = {};
            this.success = false;
            this.loading = true;

            let vm = this;

            this.$http.post(this.routes['admin-member-notes-delete-flag'], {
                id: id,
            })
                .then((response) => {

                    const data = response.data;

                    if (data.errors) {
                        vm.errors = data.errors;
                        this.loading = false;
                        return;
                    }
                    if (data.success) {
                        vm.success = data.success;
                    }
                    vm.showConfirmDeletion(-1);
                    vm.load();
                    vm.emitEvent('flagsChanged');
                });
        },
        toggleStatus(id, status) {
            if (this.loading) {
                return;
            }
            this.errors = {};
            this.loading = true;

            let vm = this;

            this.$http.post(this.routes['admin-member-notes-toggle-flag-status'], {
                id: id,
                status: status,
            })
                .then((response) => {

                    const data = response.data;
                    this.loading = false;

                    if (data.errors) {
                        vm.errors = data.errors;
                        return;
                    }
                    if (data.success) {
                        for (let i = 0; i < vm.flags.length; i++) {
                            if (vm.flags[i].id == id) {
                                vm.flags[i].status = status;
                                break;
                            }
                        }
                        vm.emitEvent('flagsChanged');
                    }
                });
        },
        emitEvent(name, data) {
            this.$parent.emitEvent(name, data);
        },
    },
});
