Vue.component('patientNotes', {

    props: [
        'routes',
        'events',
    ],

    data: function() {
        return {
            notes: [],
            loading: false,
            errors: {},
            success: false,
            display: 5,
            eventIndex: 0,
        };
    },

    mounted: function() {
        this.init();
    },

    watch: {
        events(stack) {
            // Because there may be more than one event at a time, loop through new events
            for (let i = this.eventIndex; i < stack.length; i++) {
                let event = stack[i];
                if (event.name === 'newNoteAdded') {
                    this.load();
                }
            }
            // Update event index so that we don't process already processed events
            this.eventIndex = stack.length;
        }
    },

    computed: {
        canLoadMore() {
            if (!this.notes.length) {
                return false;
            }
            return this.notes.length > this.display;
        }
    },

    methods: {
        init() {
            this.load();
        },
        load() {
            this.loading = true;
            let vm = this;

            this.$http.post(this.routes['admin-member-notes-load'], [])
                .then((response) => {

                    const data = response.data;

                    vm.notes = data.notes;
                    vm.loading = false;
                });
        },
        loadMore() {
            this.display += 5;
        },
        addNoteAction() {
            this.emitEvent('initAddNote');
        },
        emitEvent(name, data) {
            this.$parent.emitEvent(name, data);
        },
    },
});
