<?php
/**
 * Basket page for shop
 * Loads and renders templates.
 * Data handling is managed in /shop/checkout/ajax.php
 *
 * @author Martins Fridenbergs
 * @version 20/08/16
 */

$path = '../../';
require_once $path . 'core/includes/header.inc.php';

$basket = new Basket();
// Reset so that the ID Service can review basket
$basket->resetSession();
$basket->Go_Basket();

$page_meta['title'] = 'Delivery | ' . config('app.name');
$page_meta['robots'] = 'noindex, nofollow';

if (!empty($member)) {
    $member->emptyPassword = $member->emptyPassword();
}

//Disable PAF
$settings['PAF_ENABLED'] = true;

// Render the template
echo $twig->render('shop/basket/index.twig', [
    'page_meta' => $page_meta,
    'basket_countries' => $basket_countries,
    'hide_inputs' => 0,
    'basket' => $basket,
    'paf_enabled' => $settings['PAF_ENABLED']
]);
