<?php

use Carbon\Carbon;
use Mtc\Core\Admin\User;
use Mtc\Core\Models\CountryState;
use Mtc\Modules\Members\Classes\Auth;
use Mtc\Modules\Members\Classes\MemberManager;
use Mtc\Modules\Members\Models\Member;
use Mtc\Plugins\Judopay\Classes\Judopay;
use Mtc\Plugins\NewsletterSignup\Classes\Newsletter;
use Mtc\Plugins\RyftPay\Classes\RyftPay;


$path = '../../';
require_once $path . 'core/includes/header.inc.php';

$order_id = request()->input('order_id');
if (!empty($order_id)) {
    $adminUser = User::getAdminUser();
    if (!empty($adminUser)) {
        $order_eloquent = MTC\Shop\Order::query()
            ->find($order_id);
        if (!Auth::isLoggedIn()) {
            // Login admin as this member
            MemberManager::loginAsMember($order_eloquent->member ?? null);
        } else {
            // Only log in as member if currently logged in as another
            if (Auth::getLoggedInMember()->id != $order_eloquent->member) {
                MemberManager::loginAsMember($order_eloquent->member ?? null);
            }
        }
    } else {
        if (!Auth::isLoggedIn()) {
            $redirect = route('members-login', [
                'redirect' => urlencode('/shop/checkout/basket_overview.php?order_id=' . $order_id),
            ], false);

            header('Location: ' . $redirect);
            exit();
        }
        $order_eloquent = MTC\Shop\Order::query()
            ->where('member', Auth::getLoggedInMember()->id)
            ->find($order_id);
    }
    if (empty($order_eloquent)) {
        header("Location: /shop/checkout/basket.php?order_not_found");
        exit();
    }
    if (!empty($order_eloquent->paid)) {
        header("Location: /shop/checkout/basket.php?order_already_paid");
        exit();
    }
    $_SESSION['basket_id'] = $order_eloquent->basket_id;
}

$basket = Basket::getCurrent();

$page_meta['title'] = $page_title = 'Payment | ' . config('app.name');
$description = '';
$keywords = '';
$_SESSION['phone_order_id'] = null;
$_SESSION['discounted_order_id'] = null;

$error = '';

if (!empty($_REQUEST['error'])) {
    $error = $_REQUEST['error'];
}

if (MEMBERS_SECTION === true && empty($member->isphoneacc)) {
    $member->isphoneacc = false;
}

if (sizeof($basket->items) == 0) {
    header('Location: basket.php?no-items');
    exit();
}

$state_list = CountryState::getCountryStateList();

// Check if there are any issues with basket validation
$request = [
    'basket' => json_decode(json_encode($basket), true),
    'terms' => 1,
    'ship_to_billing_address' => empty($_SESSION['ship_to_billing_address']) ? 1 : $_SESSION['ship_to_billing_address']
];
$errors = $basket->validate($request, $basket_countries, $state_list);
if (!empty($errors)) {
    header('Location: basket.php');
    exit();
}

if (!empty($_COOKIE['ref']) || !empty($_COOKIE['keywords'])) {
    \Mtc\Shop\Basket::query()
        ->where('id', $_SESSION['basket_id'])
        ->update([
            'ref' => $_COOKIE['ref'],
            'keywords' => $_COOKIE['keywords'],
        ]);
}

if ($order_id) {
    $newbasket = $order_eloquent->basket;
    $newbasket->order_id = $order_eloquent->id;
} else {
    $newbasket = MTC\Shop\Order::newOrder($basket);
}

// If the ID check failed during creating the order we need to redirect back and ask for more info
if (!empty($_SESSION['ID_CHECK_STATUS']) && $_SESSION['ID_CHECK_STATUS'] === \Mtc\Plugins\LexisNexisIDU\Classes\IDService::ID_CHECK_FAILED) {
    header('Location: /shop/checkout/basket.php?ID-Verification');
    exit();
}

// store Google Analytics cookie value
if (!empty($_COOKIE['_ga'])) {
    \Mtc\Shop\Order::query()
        ->where('id', $newbasket->order_id)
        ->update([
            'ga_ga' => $_COOKIE['_ga'],
        ]);
}


if (!empty($_SESSION['ID_CHECK_STATUS']) && $_SESSION['ID_CHECK_STATUS'] === \Mtc\Plugins\LexisNexisIDU\Classes\IDService::ID_CHECK_FAILED_CASCADE) {
    $failed_id_check = true;
    Mtc\Shop\Order::query()
        ->where('id', $newbasket->order_id)
        ->update([
            'failed_id_check' => Carbon::now()->format('Y-m-d H:i:s')
        ]);
}

ob_start();

if ($basket->cost_total >= 0.01) {

    if (DEV_MODE || config('ecom.test_mode')) {
        require_once $path . 'shop/checkout/phone_order/order_part3_phone.php';
    }

    if (defined('PAYPAL') && PAYPAL === true) {
        require_once $path . 'shop/checkout/paypal/order_part3_paypal.php';
    }

    if (defined('SAGEPAY') && SAGEPAY === true) {
        require_once $path . 'shop/checkout/sagepay/order_part3_protx.php';
    } elseif (SAGEPAY_SERVER === true) {
        require_once $path . 'shop/checkout/server/payment-form.php';
    }

    if (defined('WORLDPAY') && WORLDPAY == true) {
        require_once $path . 'shop/checkout/worldpay/order_part3_worldpay.php';
    }

    if (defined('STRIPE') && STRIPE === true) {
        require_once $path . 'shop/checkout/stripe/stripe.form.php';
    }

    if (defined('BARCLAYCARD') && BARCLAYCARD) {
        require_once($path . 'shop/checkout/barclaycard/order_part3_barclaycard.php');
    }

    if (defined('BANK_OF_IRELAND') && BANK_OF_IRELAND == true) {
        require_once $path . 'shop/checkout/bank_of_ireland/form.php';
    }

    if(config('judopay.enabled')) {
        Judopay::form();
    }

    if (config('ryftpay.enabled')) {
        RyftPay::form($newbasket);
    }

    /*
     * To allow more dynamic approach of adding payment gateways we are triggering an event to allow
     * registering them. This is a lot cleaner than hard-coding each payment gateway here.
     * Each payment gateway must return a rendered html template of the payment gateway form
     */
    $additional_gateways = Illuminate\Support\Facades\Event::dispatch('shop.checkout.load_payment_gateways', $newbasket);

    // Loop through and echo gateways;
    foreach ($additional_gateways as $gateway) {
        echo $gateway;
    }

} else {
    require_once $path . 'shop/checkout/discounted/order_part3_discounted.php';
}

$payment_form = ob_get_clean();

$shop_data = [
    'basket' => isset($basket) ? $basket : null,
];

$data = [
    'failed_id_check_message' => !empty($failed_id_check),
    'page_meta' => $page_meta,
    'settings' => $settings,
    'shop' => $shop_data,
    'payment_form' => $payment_form,
    'hide_inputs' => true,
    'billing_country' => $basket_countries[$basket->address['billing']['country']],
    'shipping_country' => $basket_countries[$basket->address['shipping']['country']],
    'order_id' => $newbasket->order_id,
    'error' => $error,
    'disable_vue' => false,
];

if (isset($state_list[$basket->address['billing']['country']][$basket->address['billing']['state']])) {
    $data['billing_state'] = $state_list[$basket->address['billing']['country']][$basket->address['billing']['state']];
} else {
    $data['billing_state'] = null;
}

if (isset($state_list[$basket->address['shipping']['country']][$basket->address['shipping']['state']])) {
    $data['shipping_state'] = $state_list[$basket->address['shipping']['country']][$basket->address['shipping']['state']];
} else {
    $data['shipping_state'] = null;
}

$data['is_consultation'] = !$basket->has_physical_items;


echo $twig->render('shop/basket/overview.twig', $data);
