<?php
/**
 * Class BasketAjaxAction
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk
 * @version 2017-02-17
 */
namespace Mtc\Shop\Events;

use Basket;

/**
 * Class BasketAjaxAction
 *
 * This is an event class.
 * This event is called at the end of Basket Ajax call
 * This means none of the default basket ajax actions have worked
 * and additional actions can attempt processing request
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk
 * @version 2017-02-17
 */
class BasketAjaxAction
{
    /**
     * @var \Basket
     */
    public $basket;

    /**
     * @var string[]
     */
    public $request;

    /**
     * BasketAjaxAction constructor.
     *
     * @param Basket $basket
     * @param string[] $request $_POST request
     */
    public function __construct(Basket $basket, Array $request)
    {
        $this->basket = $basket;
        $this->request= $request;
    }
}