Vue.component('account-verification', {
    props: [
        'emailIn',
        'contactNoIn',
    ],
    data: function () {
        return {
            delivery_method: 'email',
            contact_no: '',
            email: '',
            errors: [],
            messages: [],
        };
    },
    created: function () {
        this.email = this.emailIn;
        this.contact_no = this.contactNoIn;
    },
    methods: {
        requestCode: function () {
            let vm = this;
            vm.errors = [];
            vm.messages = [];
            vm.$http.post('/members/send-verification-code', {
                'method': vm.delivery_method,
                'email': vm.email,
                'contact_no': vm.contact_no
            }).then(function (response) {
                vm.messages = response.data.messages;
                vm.errors = response.data.errors;
            }).catch(function (response) {
                vm.errors = response.data.errors;
            });
        }
    }
});
