<?php
/**
 * The AdminLoadPageEvent event that fires before loading any CMS page in the admin
 *
 * There are two events for when the page loads in the CMS:
 * 1. A hook called "load_page" in the loadPage() method of the ContentManager class which fires on the front-end
 *    when a page is found and attempting to load it and in other places where you want to also load things like
 *    multi language and grid.
 * 2. A Laravel Event for AdminLoadPageEvent that fires each time a page is about to get loaded for the ADMIN area.
 *
 * @author Florin Radica <florin.radica@mtcmedia.co.uk>
 * @since 04/07/2017
 */

namespace Mtc\Cms\Events;

/**
 * Class AdminLoadPageEvent
 *
 * @package Mtc\Cms\Events
 */
class AdminLoadPageEvent
{
    /**
     * @var int $page_id The ID of the page that is being loaded
     */
    public $page_id;

    /**
     * AdminLoadPageEvent constructor.
     *
     * Check the file comments for details on this event.
     *
     * @param int $page_id The ID of the page that is being loaded
     */
    public function __construct($page_id)
    {
        $this->page_id = (int) $page_id;
    }
}
