<?php
/**
 * The model for PageList
 * @author Rihards Silins <rihards.silins@mtcmedia.co.uk>
 * @copyright MTC media Ltd
 * @version 5 14/05/2016
 */
namespace Mtc\Cms\Models;

class PageList extends \Illuminate\Database\Eloquent\Model
{
    /**
     * Indicates the db table of the model
     * @var string
     */
    protected $table = "page_list";
    /**
     * Indicates if the model should be timestamped.
     * @var bool
     */
    public $timestamps = false;
    /**
     * Belongs To Many Relationship to Department model
     * @return Illuminate\Database\Eloquent\Relations\BelongsToMany $relationship
    */
    public function items()
    {
        return $this->hasMany("Mtc\Cms\Models\PageListItem", "page_list_id");
    }

    /**
     * Class called on model boot
     * Place to attach event listeners.
     */
    protected static function boot() : void
    {
        parent::boot();

        static::deleting(function($page_list) {
            /*
             * We will actually pull the models from the database table and call delete on
             * each of them individually so that their events get fired properly with a
             * correct set of attributes in case the developers wants to check these.
             */
            foreach ($page_list->items()->get() as $page_list_item) {
                $page_list_item->delete();
            }
        });
    }
}
