<?php
/**
 * The model for PageListItem
 * @author Rihards Silins <rihards.silins@mtcmedia.co.uk>
 * @copyright MTC media Ltd
 * @version 5 14/05/2016
 */
namespace Mtc\Cms\Models;

class PageListItem extends \Illuminate\Database\Eloquent\Model
{
    /**
     * Indicates the db table of the model
     * @var string
     */
    protected $table = "page_list_item";
    /**
     * Indicates if the model should be timestamped.
     * @var bool
     */
    public $timestamps = false;
    /**
     * Belongs To Many Relationship to Department model
     * @return Illuminate\Database\Eloquent\Relations\BelongsToMany $relationship
    */
    public function data()
    {
        return $this->hasMany("Mtc\Cms\Models\PageListItemData");
    }

    /**
     * Class called on model boot
     * Place to attach event listeners.
     */
    protected static function boot() : void
    {
        parent::boot();

        static::deleting(function($page_list_item) {
            /*
             * We will actually pull the models from the database table and call delete on
             * each of them individually so that their events get fired properly with a
             * correct set of attributes in case the developers wants to check these.
             */
            foreach ($page_list_item->data()->get() as $page_list_item_data) {
                $page_list_item_data->delete();
            }
        });
    }
}
