<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Hash;
use Mtc\Modules\Members\Models\Member;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Model>
 */
class MemberFactory extends Factory
{
    protected $model = Member::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $conditions = collect([
            'Asthma',
            'Diabetes',
            'High blood pressure',
            'Anxiety',
            'Depression',
            'Arthritis',
            'Heart condition'
        ])->random(rand(0, 3))->values()->all();

        $medications = collect([
            'Ibuprofen',
            'Metformin',
            'Paracetamol',
            'Lisinopril',
            'Atorvastatin',
            'Omeprazole'
        ])->random(rand(0, 3))->values()->all();

        $allergies = collect([
            'Peanuts',
            'Shellfish',
            'Penicillin',
            'Dust mites',
            'Latex',
            'Pollen'
        ])->random(rand(0, 2))->values()->all();

        $dob = fake()->dateTimeBetween('-1 month', 'now')->format('Y-m-d');

        return [
            'email' => fake()->unique()->safeEmail(),
            'password' => Hash::make('Password123'),
            'contact_no' => fake()->numerify('07#########'),
            'hash' => '',
            'conditions' => json_encode($conditions),
            'medications' => json_encode($medications),
            'allergies' => json_encode($allergies),
            'basket_id' => 0,
            'optout' => 0,
            'prescription_reminder_email' => 0,
            'prescription_reminder_sms' => 0,
            'last_login' => fake()->dateTimeBetween('-1 month', 'now')->format('Y-m-d H:i:s'),
            'last_failed_login' => fake()->dateTimeBetween('-1 month', 'now')->format('Y-m-d H:i:s'),
            'failed_login_count' => 0,
            'created_at' => fake()->dateTimeBetween('-1 month', 'now')->format('Y-m-d H:i:s'),
            'updated_at' => fake()->dateTimeBetween('-1 month', 'now')->format('Y-m-d H:i:s'),
            'first_login' => fake()->dateTimeBetween('-1 month', 'now')->format('Y-m-d H:i:s'),
            'account_verified' => fake()->dateTimeBetween('-1 month', 'now')->format('Y-m-d H:i:s'),
            'verification_code' => '',
            'verification_code_expiry' => '',
            'phone_prefix' => '+44',
            'passed_id_check' => NULL,
            'dob' => $dob,
            'gender' => fake()->randomElement(['Male', 'Female']),
            'height' => NULL,
            'doctor_surgery' => '',
            'has_nominated_client_as_pharmacy_of_choice' => 0,
            'confirmed_terms_at' => NULL,
        ];
    }
}
