Vue.component('patientProfile', {

    props: [
        'patientData',
        'routes',
        'events',
    ],

    data: function() {
        return {
            component: 'profile',
            patient: {},
            tabs: {
                profile: {
                    name: 'Profile'
                },
                track: {
                    name: 'Track'
                },
            },
            activeTab: 'profile',
            addNote: false,
            addNoteParams: {},
            editTreatment: false,
            treatment: {},
            eventIndex: 0,
            deliveryMethods: [],
            orderParentId: null,
            siteUrl: '',
            showBasketBuilder: false,
            showReview: false,
            reviewId: null,
        };
    },

    mounted: function() {
        this.init();
    },

    watch: {
        events(stack) {
            // Because there may be more than one event at a time, loop through new events
            for (let i = this.eventIndex; i < stack.length; i++) {
                let event = stack[i];
                if (event.name === 'addNoteClosed') {
                    this.addNote = false;
                }
                if (event.name === 'editTreatmentClosed') {
                    this.editTreatment = false;
                    this.treatment = {};
                }
                if (event.name === 'initAddNote') {
                    this.addNote = true;
                    this.addNoteParams = event.data;
                }
                if (event.name === 'initBasketBuilder') {
                    this.showBasketBuilder = true;
                    this.orderParentId = event.data.orderId;
                }
                if (event.name === 'initEditTreatment') {
                    this.editTreatment = true;
                    this.treatment = event.data.treatment;
                }
                if (event.name === 'ordersLoaded') {
                    this.bindAddNoteAction();
                    this.bindBasketBuilderAction();
                }
                if (event.name === 'reviewsLoaded') {
                    this.bindEditReviewAction();
                }
                if (event.name === 'treatmentsLoaded') {
                    this.bindEditTreatmentAction();
                }
                if (event.name === 'initReview') {
                    this.showReview = true;
                    this.reviewId = event.data.reviewId;
                }
            }
            // Update event index so that we don't process already processed events
            this.eventIndex = stack.length;
        }
    },

    methods: {
        init() {
            this.patient = this.patientData;

            this.bindAddNoteAction();
            this.bindEditTreatmentAction();
            this.bindBasketBuilderAction();
            this.bindEditReviewAction();
        },
        setTab(tabName) {
            this.activeTab = tabName;
        },
        emitEvent(name, data) {
            this.$parent.emitEvent(name, data)
        },
        bindAddNoteAction() {
            let vm = this;
            vm.$nextTick(function () {
                $('.addPatientNoteButton').mtcOverlay({
                    onClose() {
                        tinyMCE.remove('#patientNotesInput');
                        vm.emitEvent('addNoteClosed');
                    },
                    onOpen() {
                        vm.$nextTick(function () {
                            simpleTinymceNew($('#patientNotesInput'), {
                                width: '100%',
                                height: 500,
                                setup: function(el) {
                                    el.on('init', function(evt) {
                                        vm.$nextTick(function () {
                                            $(window).trigger('resize.overlay');
                                        });
                                    });
                                }
                            });
                        });
                    }
                });
            });
        },
        bindBasketBuilderAction() {
            let vm = this;
            vm.$nextTick(function () {
                $('.addOrderButton').mtcOverlay({
                    onClose() {
                        vm.emitEvent('hideBasketBuilder');
                    },
                });
            });
        },
        bindEditTreatmentAction() {
            let vm = this;
            vm.$nextTick(function () {
                $('.editPatientTreatmentButton').mtcOverlay({
                    onClose() {
                        vm.emitEvent('editTreatmentClosed');
                    },
                    onOpen() {

                    }
                });
            });
        },
        bindEditReviewAction() {
            let vm = this;
            vm.$nextTick(function () {
                $('.editReviewButton').mtcOverlay({
                    onClose() {
                        vm.emitEvent('hideReview');
                    },
                });
            });
        },
    },
});
