<?php
namespace Mtc\Plugins\SMS\Classes;

use Twilio\Rest\Client;

class Twilio
{

    /**
     * @var string $from_nr valid Twilio number
     */
    protected static $from_nr = SMS_TWILIO_FROM_NUMBER;

    /**
     * Send a SMS to recipient_nr
     *
     * @param string $recipient_nr phone number where to send the message
     * @param string $message message to send
     * @return string unique identifier for messages
     */
    public static function sendMessage($recipient_nr, $message)
    {
        $client = self::getClient();
        $message = $client->messages->create(
            $recipient_nr,
            [
                'from' => self::$from_nr,
                'body' => $message
            ]
        );
        return $message->sid;
    }

    /**
     * Create Twilio client
     * Client is created based on whether test or live mode is enabled
     *
     * @return Client
     */
    public static function getClient()
    {
        if (SMS_TWILIO_TEST === true) {
            return new Client(SMS_TWILIO_SID_TEST, SMS_TWILIO_TOKEN_TEST);
        } else {
            return new Client(SMS_TWILIO_SID, SMS_TWILIO_TOKEN);
        }
    }
}